package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChangeSetHookTargetDetails(
    targetType: Optional[zio.aws.cloudformation.model.HookTargetType] =
      Optional.Absent,
    resourceTargetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails = {
    import ChangeSetHookTargetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
      .builder()
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        resourceTargetDetails.map(value => value.buildAwsValue())
      )(_.resourceTargetDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly =
    zio.aws.cloudformation.model.ChangeSetHookTargetDetails
      .wrap(buildAwsValue())
}
object ChangeSetHookTargetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ChangeSetHookTargetDetails =
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails(
        targetType.map(value => value),
        resourceTargetDetails.map(value => value.asEditable)
      )
    def targetType: Optional[zio.aws.cloudformation.model.HookTargetType]
    def resourceTargetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ]
    def getTargetType
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookTargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getResourceTargetDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceTargetDetails", resourceTargetDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ) extends zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly {
    override val targetType
        : Optional[zio.aws.cloudformation.model.HookTargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value => zio.aws.cloudformation.model.HookTargetType.wrap(value))
    override val resourceTargetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTargetDetails())
      .map(value =>
        zio.aws.cloudformation.model.ChangeSetHookResourceTargetDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHookTargetDetails
  ): zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly =
    new Wrapper(impl)
}
