package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDescribeTypeConfigurationsRequest(
    typeConfigurationIdentifiers: Iterable[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest = {
    import BatchDescribeTypeConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
      .builder()
      .typeConfigurationIdentifiers(typeConfigurationIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest.ReadOnly =
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest
      .wrap(buildAwsValue())
}
object BatchDescribeTypeConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest =
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest(
        typeConfigurationIdentifiers.map { item =>
          item.asEditable
        }
      )
    def typeConfigurationIdentifiers: List[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]
    def getTypeConfigurationIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]] = ZIO.succeed(typeConfigurationIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
  ) extends zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest.ReadOnly {
    override val typeConfigurationIdentifiers: List[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ] = impl
      .typeConfigurationIdentifiers()
      .asScala
      .map { item =>
        zio.aws.cloudformation.model.TypeConfigurationIdentifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest
  ): zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
