package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ResourceStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ResourceStatus
}
object ResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ResourceStatus
  ): zio.aws.cloudformation.model.ResourceStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_SKIPPED =>
      val r = DELETE_SKIPPED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_FAILED =>
      val r = IMPORT_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_COMPLETE =>
      val r = IMPORT_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_IN_PROGRESS =>
      val r = IMPORT_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_IN_PROGRESS =>
      val r = IMPORT_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_FAILED =>
      val r = IMPORT_ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_COMPLETE =>
      val r = IMPORT_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_IN_PROGRESS =>
      val r = UPDATE_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_COMPLETE =>
      val r = UPDATE_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_FAILED =>
      val r = UPDATE_ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_IN_PROGRESS =>
      val r = ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_COMPLETE =>
      val r = ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_FAILED =>
      val r = ROLLBACK_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_FAILED
  }
  case object CREATE_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.CREATE_COMPLETE
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_FAILED
  }
  case object DELETE_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_COMPLETE
  }
  case object DELETE_SKIPPED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.DELETE_SKIPPED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_FAILED
  }
  case object UPDATE_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_COMPLETE
  }
  case object IMPORT_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_FAILED
  }
  case object IMPORT_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_COMPLETE
  }
  case object IMPORT_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_IN_PROGRESS
  }
  case object IMPORT_ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_IN_PROGRESS
  }
  case object IMPORT_ROLLBACK_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_FAILED
  }
  case object IMPORT_ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.IMPORT_ROLLBACK_COMPLETE
  }
  case object UPDATE_ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_IN_PROGRESS
  }
  case object UPDATE_ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_COMPLETE
  }
  case object UPDATE_ROLLBACK_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.UPDATE_ROLLBACK_FAILED
  }
  case object ROLLBACK_IN_PROGRESS
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_IN_PROGRESS
  }
  case object ROLLBACK_COMPLETE
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_COMPLETE
  }
  case object ROLLBACK_FAILED
      extends zio.aws.cloudformation.model.ResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceStatus =
      software.amazon.awssdk.services.cloudformation.model.ResourceStatus.ROLLBACK_FAILED
  }
}
