package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ResourceAttribute {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute
}
object ResourceAttribute {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ResourceAttribute
  ): zio.aws.cloudformation.model.ResourceAttribute = value match {
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.PROPERTIES =>
      val r = Properties
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.METADATA =>
      val r = Metadata
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.CREATION_POLICY =>
      val r = CreationPolicy
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.UPDATE_POLICY =>
      val r = UpdatePolicy
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.DELETION_POLICY =>
      val r = DeletionPolicy
      r
    case software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.TAGS =>
      val r = Tags
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object Properties
      extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.PROPERTIES
  }
  case object Metadata extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.METADATA
  }
  case object CreationPolicy
      extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.CREATION_POLICY
  }
  case object UpdatePolicy
      extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.UPDATE_POLICY
  }
  case object DeletionPolicy
      extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.DELETION_POLICY
  }
  case object Tags extends zio.aws.cloudformation.model.ResourceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ResourceAttribute =
      software.amazon.awssdk.services.cloudformation.model.ResourceAttribute.TAGS
  }
}
