package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ProvisioningType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.ProvisioningType
}
object ProvisioningType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ProvisioningType
  ): zio.aws.cloudformation.model.ProvisioningType = value match {
    case software.amazon.awssdk.services.cloudformation.model.ProvisioningType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ProvisioningType.NON_PROVISIONABLE =>
      val r = NON_PROVISIONABLE
      r
    case software.amazon.awssdk.services.cloudformation.model.ProvisioningType.IMMUTABLE =>
      val r = IMMUTABLE
      r
    case software.amazon.awssdk.services.cloudformation.model.ProvisioningType.FULLY_MUTABLE =>
      val r = FULLY_MUTABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ProvisioningType =
      software.amazon.awssdk.services.cloudformation.model.ProvisioningType.UNKNOWN_TO_SDK_VERSION
  }
  case object NON_PROVISIONABLE
      extends zio.aws.cloudformation.model.ProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ProvisioningType =
      software.amazon.awssdk.services.cloudformation.model.ProvisioningType.NON_PROVISIONABLE
  }
  case object IMMUTABLE extends zio.aws.cloudformation.model.ProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ProvisioningType =
      software.amazon.awssdk.services.cloudformation.model.ProvisioningType.IMMUTABLE
  }
  case object FULLY_MUTABLE
      extends zio.aws.cloudformation.model.ProvisioningType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ProvisioningType =
      software.amazon.awssdk.services.cloudformation.model.ProvisioningType.FULLY_MUTABLE
  }
}
