package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{NextToken, StackName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStackResourcesRequest(
    stackName: StackName,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest = {
    import ListStackResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackResourcesRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStackResourcesRequest.wrap(buildAwsValue())
}
object ListStackResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackResourcesRequest =
      zio.aws.cloudformation.model
        .ListStackResourcesRequest(stackName, nextToken.map(value => value))
    def stackName: StackName
    def nextToken: Optional[NextToken]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest
  ) extends zio.aws.cloudformation.model.ListStackResourcesRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest
  ): zio.aws.cloudformation.model.ListStackResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
