package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  BoxedMaxResults,
  NextToken,
  StackNameOrId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStackResourceDriftsRequest(
    stackName: StackNameOrId,
    stackResourceDriftStatusFilters: Optional[
      Iterable[zio.aws.cloudformation.model.StackResourceDriftStatus]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[BoxedMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest = {
    import DescribeStackResourceDriftsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        stackResourceDriftStatusFilters.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stackResourceDriftStatusFiltersWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => BoxedMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest
      .wrap(buildAwsValue())
}
object DescribeStackResourceDriftsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest =
      zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest(
        stackName,
        stackResourceDriftStatusFilters.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def stackName: StackNameOrId
    def stackResourceDriftStatusFilters
        : Optional[List[zio.aws.cloudformation.model.StackResourceDriftStatus]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[BoxedMaxResults]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getStackResourceDriftStatusFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackResourceDriftStatus
    ]] = AwsError.unwrapOptionField(
      "stackResourceDriftStatusFilters",
      stackResourceDriftStatusFilters
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest
  ) extends zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val stackResourceDriftStatusFilters: Optional[
      List[zio.aws.cloudformation.model.StackResourceDriftStatus]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackResourceDriftStatusFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackResourceDriftStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val maxResults: Optional[BoxedMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.cloudformation.model.primitives.BoxedMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest
  ): zio.aws.cloudformation.model.DescribeStackResourceDriftsRequest.ReadOnly =
    new Wrapper(impl)
}
