package zio.aws.cloudformation
import zio.aws.cloudformation.model.DescribeTypeResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.cloudformation.model.{
  CreateChangeSetRequest,
  SetTypeDefaultVersionRequest,
  ListStackInstancesRequest,
  GetStackPolicyRequest,
  ValidateTemplateRequest,
  DescribeStacksRequest,
  CreateStackInstancesRequest,
  CreateStackSetRequest,
  ActivateTypeRequest,
  DeactivateTypeRequest,
  ListImportsRequest,
  UpdateTerminationProtectionRequest,
  UpdateStackInstancesRequest,
  DescribeStackResourcesRequest,
  RegisterPublisherRequest,
  ListStackSetOperationResultsRequest,
  ListTypeRegistrationsRequest,
  DescribePublisherRequest,
  DescribeTypeRegistrationRequest,
  DescribeStackResourceDriftsRequest,
  SetTypeConfigurationRequest,
  ListStackResourcesRequest,
  RecordHandlerProgressRequest,
  ListExportsRequest,
  DetectStackSetDriftRequest,
  DeleteStackInstancesRequest,
  PublishTypeRequest,
  DeleteStackRequest,
  DeleteStackSetRequest,
  ListTypesRequest,
  DescribeStackEventsRequest,
  ExecuteChangeSetRequest,
  StopStackSetOperationRequest,
  DescribeStackSetOperationRequest,
  DescribeStackSetRequest,
  RollbackStackRequest,
  TestTypeRequest,
  ContinueUpdateRollbackRequest,
  ListTypeVersionsRequest,
  DetectStackResourceDriftRequest,
  CancelUpdateStackRequest,
  GetTemplateSummaryRequest,
  DeleteChangeSetRequest,
  DescribeStackDriftDetectionStatusRequest,
  UpdateStackSetRequest,
  ListStackSetsRequest,
  DescribeStackResourceRequest,
  DescribeAccountLimitsRequest,
  DetectStackDriftRequest,
  DescribeStackInstanceRequest,
  SetStackPolicyRequest,
  DescribeTypeRequest,
  ListChangeSetsRequest,
  GetTemplateRequest,
  DescribeChangeSetHooksRequest,
  SignalResourceRequest,
  ListStackSetOperationsRequest,
  EstimateTemplateCostRequest,
  ListStacksRequest,
  ImportStacksToStackSetRequest,
  DeregisterTypeRequest,
  UpdateStackRequest,
  BatchDescribeTypeConfigurationsRequest,
  CreateStackRequest,
  DescribeChangeSetRequest,
  RegisterTypeRequest
}
import software.amazon.awssdk.services.cloudformation.model.{
  CreateStackInstancesResponse,
  ListTypeVersionsResponse,
  ListExportsResponse,
  ListTypesResponse,
  DetectStackResourceDriftResponse,
  StackSummary,
  DetectStackDriftResponse,
  StackResourceDrift,
  DescribeStackSetResponse,
  DescribeAccountLimitsResponse,
  DescribeStackResourceDriftsResponse,
  TypeVersionSummary,
  UpdateStackResponse,
  CreateStackSetResponse,
  ListTypeRegistrationsResponse,
  StackSetSummary,
  SetTypeConfigurationResponse,
  DescribeTypeResponse,
  ChangeSetSummary,
  DescribeStackEventsResponse,
  UpdateStackSetResponse,
  RegisterTypeResponse,
  DescribeTypeRegistrationResponse,
  SetStackPolicyResponse,
  GetTemplateResponse,
  StackSetOperationResultSummary,
  CreateChangeSetResponse,
  StopStackSetOperationResponse,
  SignalResourceResponse,
  DescribeChangeSetResponse,
  TestTypeResponse,
  GetTemplateSummaryResponse,
  ContinueUpdateRollbackResponse,
  ListChangeSetsResponse,
  AccountLimit,
  DeregisterTypeResponse,
  DetectStackSetDriftResponse,
  DeleteChangeSetResponse,
  DeleteStackResponse,
  DescribeStackDriftDetectionStatusResponse,
  StackEvent,
  EstimateTemplateCostResponse,
  UpdateTerminationProtectionResponse,
  StackResourceSummary,
  ImportStacksToStackSetResponse,
  ValidateTemplateResponse,
  DeleteStackSetResponse,
  DescribeStackResourcesResponse,
  CreateStackResponse,
  DeleteStackInstancesResponse,
  RegisterPublisherResponse,
  ListStackSetOperationResultsResponse,
  ListStackSetsResponse,
  Change,
  Stack,
  DescribeStackInstanceResponse,
  CancelUpdateStackResponse,
  RollbackStackResponse,
  StackSetOperationSummary,
  UpdateStackInstancesResponse,
  Export,
  TypeSummary,
  DescribeChangeSetHooksResponse,
  GetStackPolicyResponse,
  ListImportsResponse,
  ExecuteChangeSetResponse,
  DeactivateTypeResponse,
  SetTypeDefaultVersionResponse,
  DescribeStacksResponse,
  StackInstanceSummary,
  ListStackResourcesResponse,
  DescribeStackSetOperationResponse,
  BatchDescribeTypeConfigurationsResponse,
  DescribePublisherResponse,
  ListStackInstancesResponse,
  ListStackSetOperationsResponse,
  DescribeStackResourceResponse,
  RecordHandlerProgressResponse,
  ListStacksResponse,
  ActivateTypeResponse,
  PublishTypeResponse,
  ChangeSetHook
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.cloudformation.{
  CloudFormationAsyncClientBuilder,
  CloudFormationAsyncClient
}
import zio.stream.ZStream
import zio.aws.cloudformation.model.primitives.{RegistrationToken, StackName}
import scala.jdk.CollectionConverters._
trait CloudFormation extends AspectSupport[CloudFormation] {
  val api: CloudFormationAsyncClient
  def listTypes(
      request: ListTypesRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.TypeSummary.ReadOnly]
  def listTypesPaginated(
      request: ListTypesRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListTypesResponse.ReadOnly]
  def deleteStackSet(
      request: DeleteStackSetRequest
  ): IO[AwsError, zio.aws.cloudformation.model.DeleteStackSetResponse.ReadOnly]
  def describeStacks(
      request: DescribeStacksRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.Stack.ReadOnly]
  def describeStacksPaginated(
      request: DescribeStacksRequest
  ): IO[AwsError, zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly]
  def executeChangeSet(request: ExecuteChangeSetRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ExecuteChangeSetResponse.ReadOnly
  ]
  def registerType(
      request: RegisterTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly]
  def describeStackSetOperation(request: DescribeStackSetOperationRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly
  ]
  def importStacksToStackSet(request: ImportStacksToStackSetRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly
  ]
  def signalResource(request: SignalResourceRequest): IO[AwsError, Unit]
  def describeStackResource(request: DescribeStackResourceRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly
  ]
  def describeStackSet(request: DescribeStackSetRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly
  ]
  def setStackPolicy(request: SetStackPolicyRequest): IO[AwsError, Unit]
  def listImports(
      request: ListImportsRequest
  ): ZStream[Any, AwsError, StackName]
  def listImportsPaginated(
      request: ListImportsRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListImportsResponse.ReadOnly]
  def describeStackEvents(
      request: DescribeStackEventsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.StackEvent.ReadOnly]
  def describeStackEventsPaginated(request: DescribeStackEventsRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly
  ]
  def updateTerminationProtection(
      request: UpdateTerminationProtectionRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly
  ]
  def describeStackInstance(request: DescribeStackInstanceRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly
  ]
  def createStackSet(
      request: CreateStackSetRequest
  ): IO[AwsError, zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly]
  def describeAccountLimits(
      request: DescribeAccountLimitsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.AccountLimit.ReadOnly]
  def describeAccountLimitsPaginated(request: DescribeAccountLimitsRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly
  ]
  def updateStackSet(
      request: UpdateStackSetRequest
  ): IO[AwsError, zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly]
  def setTypeDefaultVersion(request: SetTypeDefaultVersionRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.ReadOnly
  ]
  def getTemplateSummary(request: GetTemplateSummaryRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly
  ]
  def listExports(
      request: ListExportsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.Export.ReadOnly]
  def listExportsPaginated(
      request: ListExportsRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListExportsResponse.ReadOnly]
  def registerPublisher(request: RegisterPublisherRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly
  ]
  def activateType(
      request: ActivateTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly]
  def publishType(
      request: PublishTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly]
  def describeStackResourceDrifts(
      request: DescribeStackResourceDriftsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
  ]
  def describeStackResourceDriftsPaginated(
      request: DescribeStackResourceDriftsRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly
  ]
  def recordHandlerProgress(request: RecordHandlerProgressRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.RecordHandlerProgressResponse.ReadOnly
  ]
  def listChangeSets(request: ListChangeSetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
  ]
  def listChangeSetsPaginated(
      request: ListChangeSetsRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly]
  def deactivateType(
      request: DeactivateTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.DeactivateTypeResponse.ReadOnly]
  def batchDescribeTypeConfigurations(
      request: BatchDescribeTypeConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly
  ]
  def createChangeSet(
      request: CreateChangeSetRequest
  ): IO[AwsError, zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly]
  def continueUpdateRollback(request: ContinueUpdateRollbackRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.ReadOnly
  ]
  def rollbackStack(
      request: RollbackStackRequest
  ): IO[AwsError, zio.aws.cloudformation.model.RollbackStackResponse.ReadOnly]
  def cancelUpdateStack(request: CancelUpdateStackRequest): IO[AwsError, Unit]
  def describeChangeSet(
      request: DescribeChangeSetRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly,
    zio.aws.cloudformation.model.Change.ReadOnly
  ]]
  def describeChangeSetPaginated(request: DescribeChangeSetRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly
  ]
  def detectStackDrift(request: DetectStackDriftRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly
  ]
  def listStacks(
      request: ListStacksRequest
  ): ZStream[Any, AwsError, zio.aws.cloudformation.model.StackSummary.ReadOnly]
  def listStacksPaginated(
      request: ListStacksRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListStacksResponse.ReadOnly]
  def deleteChangeSet(
      request: DeleteChangeSetRequest
  ): IO[AwsError, zio.aws.cloudformation.model.DeleteChangeSetResponse.ReadOnly]
  def describeTypeRegistration(request: DescribeTypeRegistrationRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly
  ]
  def listStackInstances(request: ListStackInstancesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
  ]
  def listStackInstancesPaginated(request: ListStackInstancesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly
  ]
  def detectStackResourceDrift(request: DetectStackResourceDriftRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly
  ]
  def describePublisher(request: DescribePublisherRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly
  ]
  def listStackSetOperationResults(
      request: ListStackSetOperationResultsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
  ]
  def listStackSetOperationResultsPaginated(
      request: ListStackSetOperationResultsRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly
  ]
  def describeChangeSetHooks(
      request: DescribeChangeSetHooksRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly,
    zio.aws.cloudformation.model.ChangeSetHook.ReadOnly
  ]]
  def describeChangeSetHooksPaginated(
      request: DescribeChangeSetHooksRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly
  ]
  def describeStackResources(request: DescribeStackResourcesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly
  ]
  def listStackSets(request: ListStackSetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackSetSummary.ReadOnly
  ]
  def listStackSetsPaginated(
      request: ListStackSetsRequest
  ): IO[AwsError, zio.aws.cloudformation.model.ListStackSetsResponse.ReadOnly]
  def describeType(request: DescribeTypeRequest): IO[AwsError, ReadOnly]
  def estimateTemplateCost(request: EstimateTemplateCostRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly
  ]
  def testType(
      request: TestTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.TestTypeResponse.ReadOnly]
  def validateTemplate(request: ValidateTemplateRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly
  ]
  def listTypeVersions(request: ListTypeVersionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
  ]
  def listTypeVersionsPaginated(request: ListTypeVersionsRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly
  ]
  def updateStack(
      request: UpdateStackRequest
  ): IO[AwsError, zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly]
  def deregisterType(
      request: DeregisterTypeRequest
  ): IO[AwsError, zio.aws.cloudformation.model.DeregisterTypeResponse.ReadOnly]
  def deleteStack(request: DeleteStackRequest): IO[AwsError, Unit]
  def stopStackSetOperation(request: StopStackSetOperationRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.StopStackSetOperationResponse.ReadOnly
  ]
  def listTypeRegistrations(
      request: ListTypeRegistrationsRequest
  ): ZStream[Any, AwsError, RegistrationToken]
  def listTypeRegistrationsPaginated(request: ListTypeRegistrationsRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly
  ]
  def setTypeConfiguration(request: SetTypeConfigurationRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly
  ]
  def updateStackInstances(request: UpdateStackInstancesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly
  ]
  def createStack(
      request: CreateStackRequest
  ): IO[AwsError, zio.aws.cloudformation.model.CreateStackResponse.ReadOnly]
  def describeStackDriftDetectionStatus(
      request: DescribeStackDriftDetectionStatusRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly
  ]
  def deleteStackInstances(request: DeleteStackInstancesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly
  ]
  def getTemplate(
      request: GetTemplateRequest
  ): IO[AwsError, zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly]
  def getStackPolicy(
      request: GetStackPolicyRequest
  ): IO[AwsError, zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly]
  def listStackSetOperations(request: ListStackSetOperationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly
  ]
  def listStackSetOperationsPaginated(
      request: ListStackSetOperationsRequest
  ): IO[
    AwsError,
    zio.aws.cloudformation.model.ListStackSetOperationsResponse.ReadOnly
  ]
  def createStackInstances(request: CreateStackInstancesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly
  ]
  def listStackResources(request: ListStackResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
  ]
  def listStackResourcesPaginated(request: ListStackResourcesRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly
  ]
  def detectStackSetDrift(request: DetectStackSetDriftRequest): IO[
    AwsError,
    zio.aws.cloudformation.model.DetectStackSetDriftResponse.ReadOnly
  ]
}
object CloudFormation {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudFormation] = customized(
    identity
  )
  def customized(
      customization: CloudFormationAsyncClientBuilder => CloudFormationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudFormation] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CloudFormationAsyncClientBuilder => CloudFormationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CloudFormation] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CloudFormationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudFormationAsyncClient, CloudFormationAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      CloudFormationAsyncClient,
      CloudFormationAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new CloudFormationImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CloudFormationImpl[R](
      override val api: CloudFormationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudFormation
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudFormation"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudFormationImpl[R1] = new CloudFormationImpl(api, newAspect, r)
    def listTypes(request: ListTypesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListTypesRequest,
      ListTypesResponse,
      TypeSummary
    ](
      "listTypes",
      api.listTypes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.typeSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.TypeSummary.wrap(item))
      .provideEnvironment(r)
    def listTypesPaginated(
        request: ListTypesRequest
    ): IO[AwsError, zio.aws.cloudformation.model.ListTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.ListTypesRequest,
        ListTypesResponse
      ]("listTypes", api.listTypes)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.ListTypesResponse.wrap)
        .provideEnvironment(r)
    def deleteStackSet(request: DeleteStackSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DeleteStackSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest,
      DeleteStackSetResponse
    ]("deleteStackSet", api.deleteStackSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DeleteStackSetResponse.wrap)
      .provideEnvironment(r)
    def describeStacks(request: DescribeStacksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.Stack.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest,
      DescribeStacksResponse,
      Stack
    ](
      "describeStacks",
      api.describeStacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.stacks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.Stack.wrap(item))
      .provideEnvironment(r)
    def describeStacksPaginated(request: DescribeStacksRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest,
      DescribeStacksResponse
    ]("describeStacks", api.describeStacks)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DescribeStacksResponse.wrap)
      .provideEnvironment(r)
    def executeChangeSet(request: ExecuteChangeSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ExecuteChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest,
      ExecuteChangeSetResponse
    ]("executeChangeSet", api.executeChangeSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ExecuteChangeSetResponse.wrap)
      .provideEnvironment(r)
    def registerType(request: RegisterTypeRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest,
      RegisterTypeResponse
    ]("registerType", api.registerType)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.RegisterTypeResponse.wrap)
      .provideEnvironment(r)
    def describeStackSetOperation(
        request: DescribeStackSetOperationRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest,
      DescribeStackSetOperationResponse
    ]("describeStackSetOperation", api.describeStackSetOperation)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeStackSetOperationResponse.wrap)
      .provideEnvironment(r)
    def importStacksToStackSet(request: ImportStacksToStackSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest,
      ImportStacksToStackSetResponse
    ]("importStacksToStackSet", api.importStacksToStackSet)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.ImportStacksToStackSetResponse.wrap)
      .provideEnvironment(r)
    def signalResource(request: SignalResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest,
        SignalResourceResponse
      ]("signalResource", api.signalResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeStackResource(request: DescribeStackResourceRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest,
      DescribeStackResourceResponse
    ]("describeStackResource", api.describeStackResource)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeStackResourceResponse.wrap)
      .provideEnvironment(r)
    def describeStackSet(request: DescribeStackSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest,
      DescribeStackSetResponse
    ]("describeStackSet", api.describeStackSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DescribeStackSetResponse.wrap)
      .provideEnvironment(r)
    def setStackPolicy(request: SetStackPolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest,
        SetStackPolicyResponse
      ]("setStackPolicy", api.setStackPolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listImports(
        request: ListImportsRequest
    ): ZStream[Any, AwsError, StackName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListImportsRequest,
      ListImportsResponse,
      java.lang.String
    ](
      "listImports",
      api.listImports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.imports().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.primitives.StackName(item))
      .provideEnvironment(r)
    def listImportsPaginated(
        request: ListImportsRequest
    ): IO[AwsError, zio.aws.cloudformation.model.ListImportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.ListImportsRequest,
        ListImportsResponse
      ]("listImports", api.listImports)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.ListImportsResponse.wrap)
        .provideEnvironment(r)
    def describeStackEvents(request: DescribeStackEventsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackEvent.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest,
      DescribeStackEventsResponse,
      StackEvent
    ](
      "describeStackEvents",
      api.describeStackEvents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.stackEvents().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackEvent.wrap(item))
      .provideEnvironment(r)
    def describeStackEventsPaginated(request: DescribeStackEventsRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest,
      DescribeStackEventsResponse
    ]("describeStackEvents", api.describeStackEvents)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DescribeStackEventsResponse.wrap)
      .provideEnvironment(r)
    def updateTerminationProtection(
        request: UpdateTerminationProtectionRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest,
      UpdateTerminationProtectionResponse
    ]("updateTerminationProtection", api.updateTerminationProtection)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.wrap)
      .provideEnvironment(r)
    def describeStackInstance(request: DescribeStackInstanceRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest,
      DescribeStackInstanceResponse
    ]("describeStackInstance", api.describeStackInstance)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeStackInstanceResponse.wrap)
      .provideEnvironment(r)
    def createStackSet(request: CreateStackSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest,
      CreateStackSetResponse
    ]("createStackSet", api.createStackSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.CreateStackSetResponse.wrap)
      .provideEnvironment(r)
    def describeAccountLimits(request: DescribeAccountLimitsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AccountLimit.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse,
      AccountLimit
    ](
      "describeAccountLimits",
      api.describeAccountLimits,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountLimits().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.AccountLimit.wrap(item))
      .provideEnvironment(r)
    def describeAccountLimitsPaginated(
        request: DescribeAccountLimitsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse
    ]("describeAccountLimits", api.describeAccountLimits)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeAccountLimitsResponse.wrap)
      .provideEnvironment(r)
    def updateStackSet(request: UpdateStackSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest,
      UpdateStackSetResponse
    ]("updateStackSet", api.updateStackSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.UpdateStackSetResponse.wrap)
      .provideEnvironment(r)
    def setTypeDefaultVersion(request: SetTypeDefaultVersionRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest,
      SetTypeDefaultVersionResponse
    ]("setTypeDefaultVersion", api.setTypeDefaultVersion)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.wrap)
      .provideEnvironment(r)
    def getTemplateSummary(request: GetTemplateSummaryRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest,
      GetTemplateSummaryResponse
    ]("getTemplateSummary", api.getTemplateSummary)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.GetTemplateSummaryResponse.wrap)
      .provideEnvironment(r)
    def listExports(
        request: ListExportsRequest
    ): ZStream[Any, AwsError, zio.aws.cloudformation.model.Export.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudformation.model.ListExportsRequest,
        ListExportsResponse,
        Export
      ](
        "listExports",
        api.listExports,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.exports().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudformation.model.Export.wrap(item))
        .provideEnvironment(r)
    def listExportsPaginated(
        request: ListExportsRequest
    ): IO[AwsError, zio.aws.cloudformation.model.ListExportsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.ListExportsRequest,
        ListExportsResponse
      ]("listExports", api.listExports)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.ListExportsResponse.wrap)
        .provideEnvironment(r)
    def registerPublisher(request: RegisterPublisherRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest,
      RegisterPublisherResponse
    ]("registerPublisher", api.registerPublisher)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.RegisterPublisherResponse.wrap)
      .provideEnvironment(r)
    def activateType(request: ActivateTypeRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest,
      ActivateTypeResponse
    ]("activateType", api.activateType)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ActivateTypeResponse.wrap)
      .provideEnvironment(r)
    def publishType(
        request: PublishTypeRequest
    ): IO[AwsError, zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest,
        PublishTypeResponse
      ]("publishType", api.publishType)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.PublishTypeResponse.wrap)
        .provideEnvironment(r)
    def describeStackResourceDrifts(
        request: DescribeStackResourceDriftsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest,
      DescribeStackResourceDriftsResponse,
      StackResourceDrift
    ](
      "describeStackResourceDrifts",
      api.describeStackResourceDrifts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.stackResourceDrifts().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackResourceDrift.wrap(item))
      .provideEnvironment(r)
    def describeStackResourceDriftsPaginated(
        request: DescribeStackResourceDriftsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest,
      DescribeStackResourceDriftsResponse
    ]("describeStackResourceDrifts", api.describeStackResourceDrifts)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.wrap)
      .provideEnvironment(r)
    def recordHandlerProgress(request: RecordHandlerProgressRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.RecordHandlerProgressResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest,
      RecordHandlerProgressResponse
    ]("recordHandlerProgress", api.recordHandlerProgress)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.RecordHandlerProgressResponse.wrap)
      .provideEnvironment(r)
    def listChangeSets(request: ListChangeSetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest,
      ListChangeSetsResponse,
      ChangeSetSummary
    ](
      "listChangeSets",
      api.listChangeSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.ChangeSetSummary.wrap(item))
      .provideEnvironment(r)
    def listChangeSetsPaginated(request: ListChangeSetsRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest,
      ListChangeSetsResponse
    ]("listChangeSets", api.listChangeSets)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ListChangeSetsResponse.wrap)
      .provideEnvironment(r)
    def deactivateType(request: DeactivateTypeRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DeactivateTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest,
      DeactivateTypeResponse
    ]("deactivateType", api.deactivateType)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DeactivateTypeResponse.wrap)
      .provideEnvironment(r)
    def batchDescribeTypeConfigurations(
        request: BatchDescribeTypeConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest,
      BatchDescribeTypeConfigurationsResponse
    ]("batchDescribeTypeConfigurations", api.batchDescribeTypeConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def createChangeSet(request: CreateChangeSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest,
      CreateChangeSetResponse
    ]("createChangeSet", api.createChangeSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.CreateChangeSetResponse.wrap)
      .provideEnvironment(r)
    def continueUpdateRollback(request: ContinueUpdateRollbackRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest,
      ContinueUpdateRollbackResponse
    ]("continueUpdateRollback", api.continueUpdateRollback)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.wrap)
      .provideEnvironment(r)
    def rollbackStack(request: RollbackStackRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.RollbackStackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest,
      RollbackStackResponse
    ]("rollbackStack", api.rollbackStack)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.RollbackStackResponse.wrap)
      .provideEnvironment(r)
    def cancelUpdateStack(
        request: CancelUpdateStackRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest,
      CancelUpdateStackResponse
    ]("cancelUpdateStack", api.cancelUpdateStack)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeChangeSet(
        request: DescribeChangeSetRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly,
      zio.aws.cloudformation.model.Change.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest,
      DescribeChangeSetResponse,
      Change
    ](
      "describeChangeSet",
      api.describeChangeSet,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.changes().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.cloudformation.model.DescribeChangeSetResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.cloudformation.model.Change.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeChangeSetPaginated(request: DescribeChangeSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest,
      DescribeChangeSetResponse
    ]("describeChangeSet", api.describeChangeSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DescribeChangeSetResponse.wrap)
      .provideEnvironment(r)
    def detectStackDrift(request: DetectStackDriftRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest,
      DetectStackDriftResponse
    ]("detectStackDrift", api.detectStackDrift)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DetectStackDriftResponse.wrap)
      .provideEnvironment(r)
    def listStacks(request: ListStacksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStacksRequest,
      ListStacksResponse,
      StackSummary
    ](
      "listStacks",
      api.listStacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.stackSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackSummary.wrap(item))
      .provideEnvironment(r)
    def listStacksPaginated(
        request: ListStacksRequest
    ): IO[AwsError, zio.aws.cloudformation.model.ListStacksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.ListStacksRequest,
        ListStacksResponse
      ]("listStacks", api.listStacks)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.ListStacksResponse.wrap)
        .provideEnvironment(r)
    def deleteChangeSet(request: DeleteChangeSetRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DeleteChangeSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest,
      DeleteChangeSetResponse
    ]("deleteChangeSet", api.deleteChangeSet)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DeleteChangeSetResponse.wrap)
      .provideEnvironment(r)
    def describeTypeRegistration(request: DescribeTypeRegistrationRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest,
      DescribeTypeRegistrationResponse
    ]("describeTypeRegistration", api.describeTypeRegistration)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.wrap)
      .provideEnvironment(r)
    def listStackInstances(request: ListStackInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest,
      ListStackInstancesResponse,
      StackInstanceSummary
    ](
      "listStackInstances",
      api.listStackInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackInstanceSummary.wrap(item))
      .provideEnvironment(r)
    def listStackInstancesPaginated(request: ListStackInstancesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest,
      ListStackInstancesResponse
    ]("listStackInstances", api.listStackInstances)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ListStackInstancesResponse.wrap)
      .provideEnvironment(r)
    def detectStackResourceDrift(request: DetectStackResourceDriftRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest,
      DetectStackResourceDriftResponse
    ]("detectStackResourceDrift", api.detectStackResourceDrift)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DetectStackResourceDriftResponse.wrap)
      .provideEnvironment(r)
    def describePublisher(request: DescribePublisherRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest,
      DescribePublisherResponse
    ]("describePublisher", api.describePublisher)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DescribePublisherResponse.wrap)
      .provideEnvironment(r)
    def listStackSetOperationResults(
        request: ListStackSetOperationResultsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest,
      ListStackSetOperationResultsResponse,
      StackSetOperationResultSummary
    ](
      "listStackSetOperationResults",
      api.listStackSetOperationResults,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cloudformation.model.StackSetOperationResultSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listStackSetOperationResultsPaginated(
        request: ListStackSetOperationResultsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest,
      ListStackSetOperationResultsResponse
    ]("listStackSetOperationResults", api.listStackSetOperationResults)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.wrap
    ).provideEnvironment(r)
    def describeChangeSetHooks(
        request: DescribeChangeSetHooksRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly,
      zio.aws.cloudformation.model.ChangeSetHook.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest,
      DescribeChangeSetHooksResponse,
      ChangeSetHook
    ](
      "describeChangeSetHooks",
      api.describeChangeSetHooks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hooks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.cloudformation.model.ChangeSetHook.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeChangeSetHooksPaginated(
        request: DescribeChangeSetHooksRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetHooksRequest,
      DescribeChangeSetHooksResponse
    ]("describeChangeSetHooks", api.describeChangeSetHooks)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.wrap)
      .provideEnvironment(r)
    def describeStackResources(request: DescribeStackResourcesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest,
      DescribeStackResourcesResponse
    ]("describeStackResources", api.describeStackResources)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.DescribeStackResourcesResponse.wrap)
      .provideEnvironment(r)
    def listStackSets(request: ListStackSetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest,
      ListStackSetsResponse,
      StackSetSummary
    ](
      "listStackSets",
      api.listStackSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackSetSummary.wrap(item))
      .provideEnvironment(r)
    def listStackSetsPaginated(request: ListStackSetsRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ListStackSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest,
      ListStackSetsResponse
    ]("listStackSets", api.listStackSets)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ListStackSetsResponse.wrap)
      .provideEnvironment(r)
    def describeType(request: DescribeTypeRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest,
        DescribeTypeResponse
      ]("describeType", api.describeType)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.DescribeTypeResponse.wrap)
        .provideEnvironment(r)
    def estimateTemplateCost(request: EstimateTemplateCostRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest,
      EstimateTemplateCostResponse
    ]("estimateTemplateCost", api.estimateTemplateCost)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.EstimateTemplateCostResponse.wrap)
      .provideEnvironment(r)
    def testType(
        request: TestTypeRequest
    ): IO[AwsError, zio.aws.cloudformation.model.TestTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.TestTypeRequest,
        TestTypeResponse
      ]("testType", api.testType)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.TestTypeResponse.wrap)
        .provideEnvironment(r)
    def validateTemplate(request: ValidateTemplateRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest,
      ValidateTemplateResponse
    ]("validateTemplate", api.validateTemplate)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ValidateTemplateResponse.wrap)
      .provideEnvironment(r)
    def listTypeVersions(request: ListTypeVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest,
      ListTypeVersionsResponse,
      TypeVersionSummary
    ](
      "listTypeVersions",
      api.listTypeVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.typeVersionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.TypeVersionSummary.wrap(item))
      .provideEnvironment(r)
    def listTypeVersionsPaginated(request: ListTypeVersionsRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest,
      ListTypeVersionsResponse
    ]("listTypeVersions", api.listTypeVersions)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ListTypeVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateStack(
        request: UpdateStackRequest
    ): IO[AwsError, zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest,
        UpdateStackResponse
      ]("updateStack", api.updateStack)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.UpdateStackResponse.wrap)
        .provideEnvironment(r)
    def deregisterType(request: DeregisterTypeRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DeregisterTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest,
      DeregisterTypeResponse
    ]("deregisterType", api.deregisterType)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DeregisterTypeResponse.wrap)
      .provideEnvironment(r)
    def deleteStack(request: DeleteStackRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest,
        DeleteStackResponse
      ]("deleteStack", api.deleteStack)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def stopStackSetOperation(request: StopStackSetOperationRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.StopStackSetOperationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest,
      StopStackSetOperationResponse
    ]("stopStackSetOperation", api.stopStackSetOperation)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.StopStackSetOperationResponse.wrap)
      .provideEnvironment(r)
    def listTypeRegistrations(
        request: ListTypeRegistrationsRequest
    ): ZStream[Any, AwsError, RegistrationToken] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest,
      ListTypeRegistrationsResponse,
      java.lang.String
    ](
      "listTypeRegistrations",
      api.listTypeRegistrations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.registrationTokenList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cloudformation.model.primitives.RegistrationToken(item)
      )
      .provideEnvironment(r)
    def listTypeRegistrationsPaginated(
        request: ListTypeRegistrationsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest,
      ListTypeRegistrationsResponse
    ]("listTypeRegistrations", api.listTypeRegistrations)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.ListTypeRegistrationsResponse.wrap)
      .provideEnvironment(r)
    def setTypeConfiguration(request: SetTypeConfigurationRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest,
      SetTypeConfigurationResponse
    ]("setTypeConfiguration", api.setTypeConfiguration)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.SetTypeConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateStackInstances(request: UpdateStackInstancesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest,
      UpdateStackInstancesResponse
    ]("updateStackInstances", api.updateStackInstances)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.UpdateStackInstancesResponse.wrap)
      .provideEnvironment(r)
    def createStack(
        request: CreateStackRequest
    ): IO[AwsError, zio.aws.cloudformation.model.CreateStackResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.CreateStackRequest,
        CreateStackResponse
      ]("createStack", api.createStack)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.CreateStackResponse.wrap)
        .provideEnvironment(r)
    def describeStackDriftDetectionStatus(
        request: DescribeStackDriftDetectionStatusRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest,
      DescribeStackDriftDetectionStatusResponse
    ](
      "describeStackDriftDetectionStatus",
      api.describeStackDriftDetectionStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.wrap
      )
      .provideEnvironment(r)
    def deleteStackInstances(request: DeleteStackInstancesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest,
      DeleteStackInstancesResponse
    ]("deleteStackInstances", api.deleteStackInstances)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DeleteStackInstancesResponse.wrap)
      .provideEnvironment(r)
    def getTemplate(
        request: GetTemplateRequest
    ): IO[AwsError, zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest,
        GetTemplateResponse
      ]("getTemplate", api.getTemplate)(request.buildAwsValue())
        .map(zio.aws.cloudformation.model.GetTemplateResponse.wrap)
        .provideEnvironment(r)
    def getStackPolicy(request: GetStackPolicyRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest,
      GetStackPolicyResponse
    ]("getStackPolicy", api.getStackPolicy)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.GetStackPolicyResponse.wrap)
      .provideEnvironment(r)
    def listStackSetOperations(request: ListStackSetOperationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest,
      ListStackSetOperationsResponse,
      StackSetOperationSummary
    ](
      "listStackSetOperations",
      api.listStackSetOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cloudformation.model.StackSetOperationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listStackSetOperationsPaginated(
        request: ListStackSetOperationsRequest
    ): IO[
      AwsError,
      zio.aws.cloudformation.model.ListStackSetOperationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest,
      ListStackSetOperationsResponse
    ]("listStackSetOperations", api.listStackSetOperations)(
      request.buildAwsValue()
    ).map(zio.aws.cloudformation.model.ListStackSetOperationsResponse.wrap)
      .provideEnvironment(r)
    def createStackInstances(request: CreateStackInstancesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest,
      CreateStackInstancesResponse
    ]("createStackInstances", api.createStackInstances)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.CreateStackInstancesResponse.wrap)
      .provideEnvironment(r)
    def listStackResources(request: ListStackResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest,
      ListStackResourcesResponse,
      StackResourceSummary
    ](
      "listStackResources",
      api.listStackResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.stackResourceSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudformation.model.StackResourceSummary.wrap(item))
      .provideEnvironment(r)
    def listStackResourcesPaginated(request: ListStackResourcesRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest,
      ListStackResourcesResponse
    ]("listStackResources", api.listStackResources)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.ListStackResourcesResponse.wrap)
      .provideEnvironment(r)
    def detectStackSetDrift(request: DetectStackSetDriftRequest): IO[
      AwsError,
      zio.aws.cloudformation.model.DetectStackSetDriftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest,
      DetectStackSetDriftResponse
    ]("detectStackSetDrift", api.detectStackSetDrift)(request.buildAwsValue())
      .map(zio.aws.cloudformation.model.DetectStackSetDriftResponse.wrap)
      .provideEnvironment(r)
  }
  def listTypes(request: ListTypesRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.TypeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTypes(request))
  def listTypesPaginated(request: ListTypesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypesPaginated(request))
  def deleteStackSet(request: DeleteStackSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DeleteStackSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStackSet(request))
  def describeStacks(request: DescribeStacksRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.Stack.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStacks(request))
  def describeStacksPaginated(request: DescribeStacksRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStacksPaginated(request))
  def executeChangeSet(request: ExecuteChangeSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ExecuteChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeChangeSet(request))
  def registerType(request: RegisterTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.RegisterTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerType(request))
  def describeStackSetOperation(request: DescribeStackSetOperationRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackSetOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackSetOperation(request))
  def importStacksToStackSet(request: ImportStacksToStackSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ImportStacksToStackSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importStacksToStackSet(request))
  def signalResource(
      request: SignalResourceRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, Unit] =
    ZIO.serviceWithZIO(_.signalResource(request))
  def describeStackResource(request: DescribeStackResourceRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackResource(request))
  def describeStackSet(request: DescribeStackSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackSet(request))
  def setStackPolicy(
      request: SetStackPolicyRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setStackPolicy(request))
  def listImports(
      request: ListImportsRequest
  ): ZStream[zio.aws.cloudformation.CloudFormation, AwsError, StackName] =
    ZStream.serviceWithStream(_.listImports(request))
  def listImportsPaginated(request: ListImportsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListImportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImportsPaginated(request))
  def describeStackEvents(request: DescribeStackEventsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStackEvents(request))
  def describeStackEventsPaginated(request: DescribeStackEventsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackEventsPaginated(request))
  def updateTerminationProtection(
      request: UpdateTerminationProtectionRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTerminationProtection(request))
  def describeStackInstance(request: DescribeStackInstanceRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackInstance(request))
  def createStackSet(request: CreateStackSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.CreateStackSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStackSet(request))
  def describeAccountLimits(request: DescribeAccountLimitsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.AccountLimit.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccountLimits(request))
  def describeAccountLimitsPaginated(
      request: DescribeAccountLimitsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeAccountLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountLimitsPaginated(request))
  def updateStackSet(request: UpdateStackSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStackSet(request))
  def setTypeDefaultVersion(request: SetTypeDefaultVersionRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.SetTypeDefaultVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setTypeDefaultVersion(request))
  def getTemplateSummary(request: GetTemplateSummaryRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplateSummary(request))
  def listExports(request: ListExportsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.Export.ReadOnly
  ] = ZStream.serviceWithStream(_.listExports(request))
  def listExportsPaginated(request: ListExportsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExportsPaginated(request))
  def registerPublisher(request: RegisterPublisherRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.RegisterPublisherResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerPublisher(request))
  def activateType(request: ActivateTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ActivateTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateType(request))
  def publishType(request: PublishTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.PublishTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishType(request))
  def describeStackResourceDrifts(
      request: DescribeStackResourceDriftsRequest
  ): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStackResourceDrifts(request))
  def describeStackResourceDriftsPaginated(
      request: DescribeStackResourceDriftsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourceDriftsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackResourceDriftsPaginated(request))
  def recordHandlerProgress(request: RecordHandlerProgressRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.RecordHandlerProgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.recordHandlerProgress(request))
  def listChangeSets(request: ListChangeSetsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChangeSets(request))
  def listChangeSetsPaginated(request: ListChangeSetsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChangeSetsPaginated(request))
  def deactivateType(request: DeactivateTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DeactivateTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deactivateType(request))
  def batchDescribeTypeConfigurations(
      request: BatchDescribeTypeConfigurationsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDescribeTypeConfigurations(request))
  def createChangeSet(request: CreateChangeSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.CreateChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChangeSet(request))
  def continueUpdateRollback(request: ContinueUpdateRollbackRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ContinueUpdateRollbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.continueUpdateRollback(request))
  def rollbackStack(request: RollbackStackRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.RollbackStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rollbackStack(request))
  def cancelUpdateStack(
      request: CancelUpdateStackRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelUpdateStack(request))
  def describeChangeSet(
      request: DescribeChangeSetRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly,
    zio.aws.cloudformation.model.Change.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeChangeSet(request))
  def describeChangeSetPaginated(request: DescribeChangeSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChangeSetPaginated(request))
  def detectStackDrift(request: DetectStackDriftRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectStackDrift(request))
  def listStacks(request: ListStacksRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStacks(request))
  def listStacksPaginated(request: ListStacksRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStacksPaginated(request))
  def deleteChangeSet(request: DeleteChangeSetRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DeleteChangeSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChangeSet(request))
  def describeTypeRegistration(request: DescribeTypeRegistrationRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTypeRegistration(request))
  def listStackInstances(request: ListStackInstancesRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStackInstances(request))
  def listStackInstancesPaginated(request: ListStackInstancesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStackInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackInstancesPaginated(request))
  def detectStackResourceDrift(request: DetectStackResourceDriftRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectStackResourceDrift(request))
  def describePublisher(request: DescribePublisherRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribePublisherResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePublisher(request))
  def listStackSetOperationResults(
      request: ListStackSetOperationResultsRequest
  ): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackSetOperationResultSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStackSetOperationResults(request))
  def listStackSetOperationResultsPaginated(
      request: ListStackSetOperationResultsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStackSetOperationResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackSetOperationResultsPaginated(request))
  def describeChangeSetHooks(
      request: DescribeChangeSetHooksRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, StreamingOutputResult[
    Any,
    zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly,
    zio.aws.cloudformation.model.ChangeSetHook.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeChangeSetHooks(request))
  def describeChangeSetHooksPaginated(
      request: DescribeChangeSetHooksRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeChangeSetHooksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChangeSetHooksPaginated(request))
  def describeStackResources(request: DescribeStackResourcesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackResources(request))
  def listStackSets(request: ListStackSetsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackSetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStackSets(request))
  def listStackSetsPaginated(request: ListStackSetsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStackSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackSetsPaginated(request))
  def describeType(
      request: DescribeTypeRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeType(request))
  def estimateTemplateCost(request: EstimateTemplateCostRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.estimateTemplateCost(request))
  def testType(request: TestTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.TestTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testType(request))
  def validateTemplate(request: ValidateTemplateRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateTemplate(request))
  def listTypeVersions(request: ListTypeVersionsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTypeVersions(request))
  def listTypeVersionsPaginated(request: ListTypeVersionsRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListTypeVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypeVersionsPaginated(request))
  def updateStack(request: UpdateStackRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.UpdateStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStack(request))
  def deregisterType(request: DeregisterTypeRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DeregisterTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterType(request))
  def deleteStack(
      request: DeleteStackRequest
  ): ZIO[zio.aws.cloudformation.CloudFormation, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStack(request))
  def stopStackSetOperation(request: StopStackSetOperationRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StopStackSetOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopStackSetOperation(request))
  def listTypeRegistrations(request: ListTypeRegistrationsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    RegistrationToken
  ] = ZStream.serviceWithStream(_.listTypeRegistrations(request))
  def listTypeRegistrationsPaginated(
      request: ListTypeRegistrationsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListTypeRegistrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypeRegistrationsPaginated(request))
  def setTypeConfiguration(request: SetTypeConfigurationRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setTypeConfiguration(request))
  def updateStackInstances(request: UpdateStackInstancesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.UpdateStackInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStackInstances(request))
  def createStack(request: CreateStackRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.CreateStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStack(request))
  def describeStackDriftDetectionStatus(
      request: DescribeStackDriftDetectionStatusRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStackDriftDetectionStatus(request))
  def deleteStackInstances(request: DeleteStackInstancesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DeleteStackInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStackInstances(request))
  def getTemplate(request: GetTemplateRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.GetTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplate(request))
  def getStackPolicy(request: GetStackPolicyRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStackPolicy(request))
  def listStackSetOperations(request: ListStackSetOperationsRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStackSetOperations(request))
  def listStackSetOperationsPaginated(
      request: ListStackSetOperationsRequest
  ): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStackSetOperationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackSetOperationsPaginated(request))
  def createStackInstances(request: CreateStackInstancesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.CreateStackInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStackInstances(request))
  def listStackResources(request: ListStackResourcesRequest): ZStream[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listStackResources(request))
  def listStackResourcesPaginated(request: ListStackResourcesRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStackResourcesPaginated(request))
  def detectStackSetDrift(request: DetectStackSetDriftRequest): ZIO[
    zio.aws.cloudformation.CloudFormation,
    AwsError,
    zio.aws.cloudformation.model.DetectStackSetDriftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectStackSetDrift(request))
}
