package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait OperationResultFilterName {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName
}
object OperationResultFilterName {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName
  ): zio.aws.cloudformation.model.OperationResultFilterName = value match {
    case software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName.OPERATION_RESULT_STATUS =>
      val r = OPERATION_RESULT_STATUS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.OperationResultFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName =
      software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object OPERATION_RESULT_STATUS
      extends zio.aws.cloudformation.model.OperationResultFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName =
      software.amazon.awssdk.services.cloudformation.model.OperationResultFilterName.OPERATION_RESULT_STATUS
  }
}
