package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait OnStackFailure {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.OnStackFailure
}
object OnStackFailure {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.OnStackFailure
  ): zio.aws.cloudformation.model.OnStackFailure = value match {
    case software.amazon.awssdk.services.cloudformation.model.OnStackFailure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.OnStackFailure.DO_NOTHING =>
      val r = DO_NOTHING
      r
    case software.amazon.awssdk.services.cloudformation.model.OnStackFailure.ROLLBACK =>
      val r = ROLLBACK
      r
    case software.amazon.awssdk.services.cloudformation.model.OnStackFailure.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.OnStackFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnStackFailure =
      software.amazon.awssdk.services.cloudformation.model.OnStackFailure.UNKNOWN_TO_SDK_VERSION
  }
  case object DO_NOTHING extends zio.aws.cloudformation.model.OnStackFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnStackFailure =
      software.amazon.awssdk.services.cloudformation.model.OnStackFailure.DO_NOTHING
  }
  case object ROLLBACK extends zio.aws.cloudformation.model.OnStackFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnStackFailure =
      software.amazon.awssdk.services.cloudformation.model.OnStackFailure.ROLLBACK
  }
  case object DELETE extends zio.aws.cloudformation.model.OnStackFailure {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OnStackFailure =
      software.amazon.awssdk.services.cloudformation.model.OnStackFailure.DELETE
  }
}
