package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  MaxResults,
  TypeArn,
  TypeName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTypeRegistrationsRequest(
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    typeArn: Optional[TypeArn] = Optional.Absent,
    registrationStatusFilter: Optional[
      zio.aws.cloudformation.model.RegistrationStatus
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest = {
    import ListTypeRegistrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(registrationStatusFilter.map(value => value.unwrap))(
        _.registrationStatusFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypeRegistrationsRequest
      .wrap(buildAwsValue())
}
object ListTypeRegistrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeRegistrationsRequest =
      zio.aws.cloudformation.model.ListTypeRegistrationsRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        typeArn.map(value => value),
        registrationStatusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def typeArn: Optional[TypeArn]
    def registrationStatusFilter
        : Optional[zio.aws.cloudformation.model.RegistrationStatus]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getRegistrationStatusFilter
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistrationStatus] =
      AwsError.unwrapOptionField(
        "registrationStatusFilter",
        registrationStatusFilter
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ) extends zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val typeArn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val registrationStatusFilter
        : Optional[zio.aws.cloudformation.model.RegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationStatusFilter())
        .map(value =>
          zio.aws.cloudformation.model.RegistrationStatus.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest
  ): zio.aws.cloudformation.model.ListTypeRegistrationsRequest.ReadOnly =
    new Wrapper(impl)
}
