package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Account,
  NextToken,
  ClientRequestToken,
  Region,
  MaxResults,
  StackSetNameOrId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStackInstanceResourceDriftsRequest(
    stackSetName: StackSetNameOrId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    stackInstanceResourceDriftStatuses: Optional[
      Iterable[zio.aws.cloudformation.model.StackResourceDriftStatus]
    ] = Optional.Absent,
    stackInstanceAccount: Account,
    stackInstanceRegion: Region,
    operationId: ClientRequestToken,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest = {
    import ListStackInstanceResourceDriftsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest
      .builder()
      .stackSetName(StackSetNameOrId.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        stackInstanceResourceDriftStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stackInstanceResourceDriftStatusesWithStrings)
      .stackInstanceAccount(
        Account.unwrap(stackInstanceAccount): java.lang.String
      )
      .stackInstanceRegion(Region.unwrap(stackInstanceRegion): java.lang.String)
      .operationId(ClientRequestToken.unwrap(operationId): java.lang.String)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest
      .wrap(buildAwsValue())
}
object ListStackInstanceResourceDriftsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest =
      zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest(
        stackSetName,
        nextToken.map(value => value),
        maxResults.map(value => value),
        stackInstanceResourceDriftStatuses.map(value => value),
        stackInstanceAccount,
        stackInstanceRegion,
        operationId,
        callAs.map(value => value)
      )
    def stackSetName: StackSetNameOrId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def stackInstanceResourceDriftStatuses
        : Optional[List[zio.aws.cloudformation.model.StackResourceDriftStatus]]
    def stackInstanceAccount: Account
    def stackInstanceRegion: Region
    def operationId: ClientRequestToken
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetNameOrId] =
      ZIO.succeed(stackSetName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStackInstanceResourceDriftStatuses: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackResourceDriftStatus
    ]] = AwsError.unwrapOptionField(
      "stackInstanceResourceDriftStatuses",
      stackInstanceResourceDriftStatuses
    )
    def getStackInstanceAccount: ZIO[Any, Nothing, Account] =
      ZIO.succeed(stackInstanceAccount)
    def getStackInstanceRegion: ZIO[Any, Nothing, Region] =
      ZIO.succeed(stackInstanceRegion)
    def getOperationId: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest
  ) extends zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest.ReadOnly {
    override val stackSetName: StackSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .StackSetNameOrId(impl.stackSetName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val stackInstanceResourceDriftStatuses: Optional[
      List[zio.aws.cloudformation.model.StackResourceDriftStatus]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackInstanceResourceDriftStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackResourceDriftStatus.wrap(item)
        }.toList
      )
    override val stackInstanceAccount: Account =
      zio.aws.cloudformation.model.primitives
        .Account(impl.stackInstanceAccount())
    override val stackInstanceRegion: Region =
      zio.aws.cloudformation.model.primitives.Region(impl.stackInstanceRegion())
    override val operationId: ClientRequestToken =
      zio.aws.cloudformation.model.primitives
        .ClientRequestToken(impl.operationId())
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackInstanceResourceDriftsRequest
  ): zio.aws.cloudformation.model.ListStackInstanceResourceDriftsRequest.ReadOnly =
    new Wrapper(impl)
}
