package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait HookFailureMode {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.HookFailureMode
}
object HookFailureMode {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.HookFailureMode
  ): zio.aws.cloudformation.model.HookFailureMode = value match {
    case software.amazon.awssdk.services.cloudformation.model.HookFailureMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.HookFailureMode.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.cloudformation.model.HookFailureMode.WARN =>
      val r = WARN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.HookFailureMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookFailureMode =
      software.amazon.awssdk.services.cloudformation.model.HookFailureMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FAIL extends zio.aws.cloudformation.model.HookFailureMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookFailureMode =
      software.amazon.awssdk.services.cloudformation.model.HookFailureMode.FAIL
  }
  case object WARN extends zio.aws.cloudformation.model.HookFailureMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookFailureMode =
      software.amazon.awssdk.services.cloudformation.model.HookFailureMode.WARN
  }
}
