package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationsAccessRequest(
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest = {
    import DescribeOrganizationsAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest
      .builder()
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeOrganizationsAccessRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeOrganizationsAccessRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationsAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeOrganizationsAccessRequest =
      zio.aws.cloudformation.model
        .DescribeOrganizationsAccessRequest(callAs.map(value => value))
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest
  ) extends zio.aws.cloudformation.model.DescribeOrganizationsAccessRequest.ReadOnly {
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessRequest
  ): zio.aws.cloudformation.model.DescribeOrganizationsAccessRequest.ReadOnly =
    new Wrapper(impl)
}
