package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait AccountFilterType {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.AccountFilterType
}
object AccountFilterType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.AccountFilterType
  ): zio.aws.cloudformation.model.AccountFilterType = value match {
    case software.amazon.awssdk.services.cloudformation.model.AccountFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountFilterType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountFilterType.INTERSECTION =>
      val r = INTERSECTION
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountFilterType.DIFFERENCE =>
      val r = DIFFERENCE
      r
    case software.amazon.awssdk.services.cloudformation.model.AccountFilterType.UNION =>
      val r = UNION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.AccountFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountFilterType =
      software.amazon.awssdk.services.cloudformation.model.AccountFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.cloudformation.model.AccountFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountFilterType =
      software.amazon.awssdk.services.cloudformation.model.AccountFilterType.NONE
  }
  case object INTERSECTION
      extends zio.aws.cloudformation.model.AccountFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountFilterType =
      software.amazon.awssdk.services.cloudformation.model.AccountFilterType.INTERSECTION
  }
  case object DIFFERENCE
      extends zio.aws.cloudformation.model.AccountFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountFilterType =
      software.amazon.awssdk.services.cloudformation.model.AccountFilterType.DIFFERENCE
  }
  case object UNION extends zio.aws.cloudformation.model.AccountFilterType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.AccountFilterType =
      software.amazon.awssdk.services.cloudformation.model.AccountFilterType.UNION
  }
}
