package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackInstanceFilterName {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName
}
object StackInstanceFilterName {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName
  ): zio.aws.cloudformation.model.StackInstanceFilterName = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.DETAILED_STATUS =>
      val r = DETAILED_STATUS
      r
    case software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.LAST_OPERATION_ID =>
      val r = LAST_OPERATION_ID
      r
    case software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.DRIFT_STATUS =>
      val r = DRIFT_STATUS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName =
      software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object DETAILED_STATUS
      extends zio.aws.cloudformation.model.StackInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName =
      software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.DETAILED_STATUS
  }
  case object LAST_OPERATION_ID
      extends zio.aws.cloudformation.model.StackInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName =
      software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.LAST_OPERATION_ID
  }
  case object DRIFT_STATUS
      extends zio.aws.cloudformation.model.StackInstanceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName =
      software.amazon.awssdk.services.cloudformation.model.StackInstanceFilterName.DRIFT_STATUS
  }
}
