package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackSetNameOrId,
  StackNameOrId,
  TemplateURL,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTemplateSummaryRequest(
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent,
    stackName: Optional[StackNameOrId] = Optional.Absent,
    stackSetName: Optional[StackSetNameOrId] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent,
    templateSummaryConfig: Optional[
      zio.aws.cloudformation.model.TemplateSummaryConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest = {
    import GetTemplateSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        stackSetName.map(value =>
          StackSetNameOrId.unwrap(value): java.lang.String
        )
      )(_.stackSetName)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .optionallyWith(
        templateSummaryConfig.map(value => value.buildAwsValue())
      )(_.templateSummaryConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateSummaryRequest.wrap(buildAwsValue())
}
object GetTemplateSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateSummaryRequest =
      zio.aws.cloudformation.model.GetTemplateSummaryRequest(
        templateBody.map(value => value),
        templateURL.map(value => value),
        stackName.map(value => value),
        stackSetName.map(value => value),
        callAs.map(value => value),
        templateSummaryConfig.map(value => value.asEditable)
      )
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def stackName: Optional[StackNameOrId]
    def stackSetName: Optional[StackSetNameOrId]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def templateSummaryConfig
        : Optional[zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getStackSetName: ZIO[Any, AwsError, StackSetNameOrId] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
    def getTemplateSummaryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateSummaryConfig", templateSummaryConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ) extends zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly {
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val stackName: Optional[StackNameOrId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val stackSetName: Optional[StackSetNameOrId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackSetName())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackSetNameOrId(value)
        )
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
    override val templateSummaryConfig: Optional[
      zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.templateSummaryConfig())
      .map(value =>
        zio.aws.cloudformation.model.TemplateSummaryConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest
  ): zio.aws.cloudformation.model.GetTemplateSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
