package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EstimateTemplateCostResponse(
    url: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse = {
    import EstimateTemplateCostResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse
      .builder()
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly =
    zio.aws.cloudformation.model.EstimateTemplateCostResponse
      .wrap(buildAwsValue())
}
object EstimateTemplateCostResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.EstimateTemplateCostResponse =
      zio.aws.cloudformation.model
        .EstimateTemplateCostResponse(url.map(value => value))
    def url: Optional[Url]
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse
  ) extends zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly {
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.cloudformation.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse
  ): zio.aws.cloudformation.model.EstimateTemplateCostResponse.ReadOnly =
    new Wrapper(impl)
}
