package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{Region, Account, StackSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStackInstanceRequest(
    stackSetName: StackSetName,
    stackInstanceAccount: Account,
    stackInstanceRegion: Region,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest = {
    import DescribeStackInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .stackInstanceAccount(
        Account.unwrap(stackInstanceAccount): java.lang.String
      )
      .stackInstanceRegion(Region.unwrap(stackInstanceRegion): java.lang.String)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackInstanceRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackInstanceRequest
      .wrap(buildAwsValue())
}
object DescribeStackInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackInstanceRequest =
      zio.aws.cloudformation.model.DescribeStackInstanceRequest(
        stackSetName,
        stackInstanceAccount,
        stackInstanceRegion,
        callAs.map(value => value)
      )
    def stackSetName: StackSetName
    def stackInstanceAccount: Account
    def stackInstanceRegion: Region
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getStackInstanceAccount: ZIO[Any, Nothing, Account] =
      ZIO.succeed(stackInstanceAccount)
    def getStackInstanceRegion: ZIO[Any, Nothing, Region] =
      ZIO.succeed(stackInstanceRegion)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest
  ) extends zio.aws.cloudformation.model.DescribeStackInstanceRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val stackInstanceAccount: Account =
      zio.aws.cloudformation.model.primitives
        .Account(impl.stackInstanceAccount())
    override val stackInstanceRegion: Region =
      zio.aws.cloudformation.model.primitives.Region(impl.stackInstanceRegion())
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest
  ): zio.aws.cloudformation.model.DescribeStackInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
