package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  DisableRollback,
  StackName,
  NotificationARN,
  DeletionTime,
  StackId,
  RoleARN,
  Description,
  EnableTerminationProtection,
  ChangeSetId,
  TimeoutMinutes,
  LastUpdatedTime,
  StackStatusReason
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Stack(
    stackId: Optional[StackId] = Optional.Absent,
    stackName: StackName,
    changeSetId: Optional[ChangeSetId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    creationTime: CreationTime,
    deletionTime: Optional[DeletionTime] = Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent,
    rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = Optional.Absent,
    stackStatus: zio.aws.cloudformation.model.StackStatus,
    stackStatusReason: Optional[StackStatusReason] = Optional.Absent,
    disableRollback: Optional[DisableRollback] = Optional.Absent,
    notificationARNs: Optional[Iterable[NotificationARN]] = Optional.Absent,
    timeoutInMinutes: Optional[TimeoutMinutes] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    outputs: Optional[Iterable[zio.aws.cloudformation.model.Output]] =
      Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    enableTerminationProtection: Optional[EnableTerminationProtection] =
      Optional.Absent,
    parentId: Optional[StackId] = Optional.Absent,
    rootId: Optional[StackId] = Optional.Absent,
    driftInformation: Optional[
      zio.aws.cloudformation.model.StackDriftInformation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Stack = {
    import Stack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Stack
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        deletionTime.map(value => DeletionTime.unwrap(value): Instant)
      )(_.deletionTime)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .stackStatus(stackStatus.unwrap)
      .optionallyWith(
        stackStatusReason.map(value =>
          StackStatusReason.unwrap(value): java.lang.String
        )
      )(_.stackStatusReason)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeoutMinutes.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableTerminationProtection.map(value =>
          EnableTerminationProtection.unwrap(value): java.lang.Boolean
        )
      )(_.enableTerminationProtection)
      .optionallyWith(
        parentId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        rootId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.rootId)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Stack.ReadOnly =
    zio.aws.cloudformation.model.Stack.wrap(buildAwsValue())
}
object Stack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Stack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Stack =
      zio.aws.cloudformation.model.Stack(
        stackId.map(value => value),
        stackName,
        changeSetId.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime,
        deletionTime.map(value => value),
        lastUpdatedTime.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        stackStatus,
        stackStatusReason.map(value => value),
        disableRollback.map(value => value),
        notificationARNs.map(value => value),
        timeoutInMinutes.map(value => value),
        capabilities.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleARN.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableTerminationProtection.map(value => value),
        parentId.map(value => value),
        rootId.map(value => value),
        driftInformation.map(value => value.asEditable)
      )
    def stackId: Optional[StackId]
    def stackName: StackName
    def changeSetId: Optional[ChangeSetId]
    def description: Optional[Description]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def creationTime: CreationTime
    def deletionTime: Optional[DeletionTime]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def rollbackConfiguration
        : Optional[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def stackStatus: zio.aws.cloudformation.model.StackStatus
    def stackStatusReason: Optional[StackStatusReason]
    def disableRollback: Optional[DisableRollback]
    def notificationARNs: Optional[List[NotificationARN]]
    def timeoutInMinutes: Optional[TimeoutMinutes]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def outputs: Optional[List[zio.aws.cloudformation.model.Output.ReadOnly]]
    def roleARN: Optional[RoleARN]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def enableTerminationProtection: Optional[EnableTerminationProtection]
    def parentId: Optional[StackId]
    def rootId: Optional[StackId]
    def driftInformation
        : Optional[zio.aws.cloudformation.model.StackDriftInformation.ReadOnly]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDeletionTime: ZIO[Any, AwsError, DeletionTime] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getStackStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.StackStatus] =
      ZIO.succeed(stackStatus)
    def getStackStatusReason: ZIO[Any, AwsError, StackStatusReason] =
      AwsError.unwrapOptionField("stackStatusReason", stackStatusReason)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeoutMinutes] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Output.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableTerminationProtection
        : ZIO[Any, AwsError, EnableTerminationProtection] =
      AwsError.unwrapOptionField(
        "enableTerminationProtection",
        enableTerminationProtection
      )
    def getParentId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getRootId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("rootId", rootId)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackDriftInformation.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Stack
  ) extends zio.aws.cloudformation.model.Stack.ReadOnly {
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val changeSetId: Optional[ChangeSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val creationTime: CreationTime =
      zio.aws.cloudformation.model.primitives.CreationTime(impl.creationTime())
    override val deletionTime: Optional[DeletionTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionTime())
      .map(value => zio.aws.cloudformation.model.primitives.DeletionTime(value))
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.cloudformation.model.primitives.LastUpdatedTime(value)
        )
    override val rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
      )
    override val stackStatus: zio.aws.cloudformation.model.StackStatus =
      zio.aws.cloudformation.model.StackStatus.wrap(impl.stackStatus())
    override val stackStatusReason: Optional[StackStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackStatusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackStatusReason(value)
        )
    override val disableRollback: Optional[DisableRollback] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableRollback())
        .map(value =>
          zio.aws.cloudformation.model.primitives.DisableRollback(value)
        )
    override val notificationARNs: Optional[List[NotificationARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.NotificationARN(item)
          }.toList
        )
    override val timeoutInMinutes: Optional[TimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInMinutes())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TimeoutMinutes(value)
        )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val outputs
        : Optional[List[zio.aws.cloudformation.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Output.wrap(item)
          }.toList
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val enableTerminationProtection
        : Optional[EnableTerminationProtection] = zio.aws.core.internal
      .optionalFromNullable(impl.enableTerminationProtection())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .EnableTerminationProtection(value)
      )
    override val parentId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.parentId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val rootId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.rootId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val driftInformation: Optional[
      zio.aws.cloudformation.model.StackDriftInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackDriftInformation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Stack
  ): zio.aws.cloudformation.model.Stack.ReadOnly = new Wrapper(impl)
}
