package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait HookStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.HookStatus
}
object HookStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.HookStatus
  ): zio.aws.cloudformation.model.HookStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.HookStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_IN_PROGRESS =>
      val r = HOOK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_COMPLETE_SUCCEEDED =>
      val r = HOOK_COMPLETE_SUCCEEDED
      r
    case software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_COMPLETE_FAILED =>
      val r = HOOK_COMPLETE_FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_FAILED =>
      val r = HOOK_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.HookStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookStatus =
      software.amazon.awssdk.services.cloudformation.model.HookStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HOOK_IN_PROGRESS extends zio.aws.cloudformation.model.HookStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookStatus =
      software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_IN_PROGRESS
  }
  case object HOOK_COMPLETE_SUCCEEDED
      extends zio.aws.cloudformation.model.HookStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookStatus =
      software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_COMPLETE_SUCCEEDED
  }
  case object HOOK_COMPLETE_FAILED
      extends zio.aws.cloudformation.model.HookStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookStatus =
      software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_COMPLETE_FAILED
  }
  case object HOOK_FAILED extends zio.aws.cloudformation.model.HookStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HookStatus =
      software.amazon.awssdk.services.cloudformation.model.HookStatus.HOOK_FAILED
  }
}
