package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  StackName,
  DeletionTime,
  TemplateDescription,
  StackId,
  LastUpdatedTime,
  StackStatusReason
}
import scala.jdk.CollectionConverters._
final case class StackSummary(
    stackId: Optional[StackId] = Optional.Absent,
    stackName: StackName,
    templateDescription: Optional[TemplateDescription] = Optional.Absent,
    creationTime: CreationTime,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent,
    deletionTime: Optional[DeletionTime] = Optional.Absent,
    stackStatus: zio.aws.cloudformation.model.StackStatus,
    stackStatusReason: Optional[StackStatusReason] = Optional.Absent,
    parentId: Optional[StackId] = Optional.Absent,
    rootId: Optional[StackId] = Optional.Absent,
    driftInformation: Optional[
      zio.aws.cloudformation.model.StackDriftInformationSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSummary = {
    import StackSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSummary
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateDescription.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        deletionTime.map(value => DeletionTime.unwrap(value): Instant)
      )(_.deletionTime)
      .stackStatus(stackStatus.unwrap)
      .optionallyWith(
        stackStatusReason.map(value =>
          StackStatusReason.unwrap(value): java.lang.String
        )
      )(_.stackStatusReason)
      .optionallyWith(
        parentId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.parentId)
      .optionallyWith(
        rootId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.rootId)
      .optionallyWith(driftInformation.map(value => value.buildAwsValue()))(
        _.driftInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSummary.wrap(buildAwsValue())
}
object StackSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSummary =
      zio.aws.cloudformation.model.StackSummary(
        stackId.map(value => value),
        stackName,
        templateDescription.map(value => value),
        creationTime,
        lastUpdatedTime.map(value => value),
        deletionTime.map(value => value),
        stackStatus,
        stackStatusReason.map(value => value),
        parentId.map(value => value),
        rootId.map(value => value),
        driftInformation.map(value => value.asEditable)
      )
    def stackId: Optional[StackId]
    def stackName: StackName
    def templateDescription: Optional[TemplateDescription]
    def creationTime: CreationTime
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def deletionTime: Optional[DeletionTime]
    def stackStatus: zio.aws.cloudformation.model.StackStatus
    def stackStatusReason: Optional[StackStatusReason]
    def parentId: Optional[StackId]
    def rootId: Optional[StackId]
    def driftInformation: Optional[
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getDeletionTime: ZIO[Any, AwsError, DeletionTime] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getStackStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.StackStatus] =
      ZIO.succeed(stackStatus)
    def getStackStatusReason: ZIO[Any, AwsError, StackStatusReason] =
      AwsError.unwrapOptionField("stackStatusReason", stackStatusReason)
    def getParentId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getRootId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("rootId", rootId)
    def getDriftInformation: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ] = AwsError.unwrapOptionField("driftInformation", driftInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSummary
  ) extends zio.aws.cloudformation.model.StackSummary.ReadOnly {
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateDescription: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateDescription())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TemplateDescription(value)
        )
    override val creationTime: CreationTime =
      zio.aws.cloudformation.model.primitives.CreationTime(impl.creationTime())
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value =>
          zio.aws.cloudformation.model.primitives.LastUpdatedTime(value)
        )
    override val deletionTime: Optional[DeletionTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionTime())
      .map(value => zio.aws.cloudformation.model.primitives.DeletionTime(value))
    override val stackStatus: zio.aws.cloudformation.model.StackStatus =
      zio.aws.cloudformation.model.StackStatus.wrap(impl.stackStatus())
    override val stackStatusReason: Optional[StackStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackStatusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackStatusReason(value)
        )
    override val parentId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.parentId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val rootId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.rootId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val driftInformation: Optional[
      zio.aws.cloudformation.model.StackDriftInformationSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.driftInformation())
      .map(value =>
        zio.aws.cloudformation.model.StackDriftInformationSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSummary
  ): zio.aws.cloudformation.model.StackSummary.ReadOnly = new Wrapper(impl)
}
