package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.OperationResultFilterValues
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OperationResultFilter(
    name: Optional[zio.aws.cloudformation.model.OperationResultFilterName] =
      Optional.Absent,
    values: Optional[OperationResultFilterValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.OperationResultFilter = {
    import OperationResultFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.OperationResultFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          OperationResultFilterValues.unwrap(value): java.lang.String
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.OperationResultFilter.ReadOnly =
    zio.aws.cloudformation.model.OperationResultFilter.wrap(buildAwsValue())
}
object OperationResultFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.OperationResultFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.OperationResultFilter =
      zio.aws.cloudformation.model.OperationResultFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[zio.aws.cloudformation.model.OperationResultFilterName]
    def values: Optional[OperationResultFilterValues]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.OperationResultFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, OperationResultFilterValues] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.OperationResultFilter
  ) extends zio.aws.cloudformation.model.OperationResultFilter.ReadOnly {
    override val name
        : Optional[zio.aws.cloudformation.model.OperationResultFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.cloudformation.model.OperationResultFilterName.wrap(value)
        )
    override val values: Optional[OperationResultFilterValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .OperationResultFilterValues(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.OperationResultFilter
  ): zio.aws.cloudformation.model.OperationResultFilter.ReadOnly = new Wrapper(
    impl
  )
}
