package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChangeSetsResponse(
    summaries: Optional[
      Iterable[zio.aws.cloudformation.model.ChangeSetSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse = {
    import ListChangeSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly =
    zio.aws.cloudformation.model.ListChangeSetsResponse.wrap(buildAwsValue())
}
object ListChangeSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListChangeSetsResponse =
      zio.aws.cloudformation.model.ListChangeSetsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries
        : Optional[List[zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse
  ) extends zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly {
    override val summaries: Optional[
      List[zio.aws.cloudformation.model.ChangeSetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ChangeSetSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse
  ): zio.aws.cloudformation.model.ListChangeSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
