package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeType
  ): zio.aws.cloudformation.model.ChangeType = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeType.RESOURCE =>
      val r = Resource
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeType =
      software.amazon.awssdk.services.cloudformation.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object Resource extends zio.aws.cloudformation.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeType =
      software.amazon.awssdk.services.cloudformation.model.ChangeType.RESOURCE
  }
}
