package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStackResourcesResponse(
    stackResourceSummaries: Optional[
      Iterable[zio.aws.cloudformation.model.StackResourceSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse = {
    import ListStackResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
      .builder()
      .optionallyWith(
        stackResourceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackResourceSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly =
    zio.aws.cloudformation.model.ListStackResourcesResponse
      .wrap(buildAwsValue())
}
object ListStackResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListStackResourcesResponse =
      zio.aws.cloudformation.model.ListStackResourcesResponse(
        stackResourceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stackResourceSummaries: Optional[
      List[zio.aws.cloudformation.model.StackResourceSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getStackResourceSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.StackResourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "stackResourceSummaries",
      stackResourceSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ) extends zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly {
    override val stackResourceSummaries: Optional[
      List[zio.aws.cloudformation.model.StackResourceSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackResourceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.StackResourceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse
  ): zio.aws.cloudformation.model.ListStackResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
