package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  LogicalResourceId,
  StackNameOrId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetectStackResourceDriftRequest(
    stackName: StackNameOrId,
    logicalResourceId: LogicalResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest = {
    import DetectStackResourceDriftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackResourceDriftRequest.ReadOnly =
    zio.aws.cloudformation.model.DetectStackResourceDriftRequest
      .wrap(buildAwsValue())
}
object DetectStackResourceDriftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DetectStackResourceDriftRequest =
      zio.aws.cloudformation.model
        .DetectStackResourceDriftRequest(stackName, logicalResourceId)
    def stackName: StackNameOrId
    def logicalResourceId: LogicalResourceId
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest
  ) extends zio.aws.cloudformation.model.DetectStackResourceDriftRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest
  ): zio.aws.cloudformation.model.DetectStackResourceDriftRequest.ReadOnly =
    new Wrapper(impl)
}
