package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait StackResourceDriftStatus {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus
}
object StackResourceDriftStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus
  ): zio.aws.cloudformation.model.StackResourceDriftStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.IN_SYNC =>
      val r = IN_SYNC
      r
    case software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.MODIFIED =>
      val r = MODIFIED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.NOT_CHECKED =>
      val r = NOT_CHECKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.StackResourceDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_SYNC
      extends zio.aws.cloudformation.model.StackResourceDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.IN_SYNC
  }
  case object MODIFIED
      extends zio.aws.cloudformation.model.StackResourceDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.MODIFIED
  }
  case object DELETED
      extends zio.aws.cloudformation.model.StackResourceDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.DELETED
  }
  case object NOT_CHECKED
      extends zio.aws.cloudformation.model.StackResourceDriftStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus =
      software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus.NOT_CHECKED
  }
}
