package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ResourceSignalUniqueId,
  LogicalResourceId,
  StackNameOrId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SignalResourceRequest(
    stackName: StackNameOrId,
    logicalResourceId: LogicalResourceId,
    uniqueId: ResourceSignalUniqueId,
    status: zio.aws.cloudformation.model.ResourceSignalStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest = {
    import SignalResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .uniqueId(ResourceSignalUniqueId.unwrap(uniqueId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.SignalResourceRequest.ReadOnly =
    zio.aws.cloudformation.model.SignalResourceRequest.wrap(buildAwsValue())
}
object SignalResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.SignalResourceRequest =
      zio.aws.cloudformation.model.SignalResourceRequest(
        stackName,
        logicalResourceId,
        uniqueId,
        status
      )
    def stackName: StackNameOrId
    def logicalResourceId: LogicalResourceId
    def uniqueId: ResourceSignalUniqueId
    def status: zio.aws.cloudformation.model.ResourceSignalStatus
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getUniqueId: ZIO[Any, Nothing, ResourceSignalUniqueId] =
      ZIO.succeed(uniqueId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.ResourceSignalStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest
  ) extends zio.aws.cloudformation.model.SignalResourceRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val uniqueId: ResourceSignalUniqueId =
      zio.aws.cloudformation.model.primitives
        .ResourceSignalUniqueId(impl.uniqueId())
    override val status: zio.aws.cloudformation.model.ResourceSignalStatus =
      zio.aws.cloudformation.model.ResourceSignalStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest
  ): zio.aws.cloudformation.model.SignalResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
