package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait OperationStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.OperationStatus
  ): zio.aws.cloudformation.model.OperationStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.OperationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.cloudformation.model.OperationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.OperationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.cloudformation.model.OperationStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationStatus =
      software.amazon.awssdk.services.cloudformation.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.cloudformation.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationStatus =
      software.amazon.awssdk.services.cloudformation.model.OperationStatus.PENDING
  }
  case object IN_PROGRESS extends zio.aws.cloudformation.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationStatus =
      software.amazon.awssdk.services.cloudformation.model.OperationStatus.IN_PROGRESS
  }
  case object SUCCESS extends zio.aws.cloudformation.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationStatus =
      software.amazon.awssdk.services.cloudformation.model.OperationStatus.SUCCESS
  }
  case object FAILED extends zio.aws.cloudformation.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.OperationStatus =
      software.amazon.awssdk.services.cloudformation.model.OperationStatus.FAILED
  }
}
