package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  HookTypeConfigurationVersionId,
  HookTypeVersionId,
  HookTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChangeSetHook(
    invocationPoint: Optional[
      zio.aws.cloudformation.model.HookInvocationPoint
    ] = Optional.Absent,
    failureMode: Optional[zio.aws.cloudformation.model.HookFailureMode] =
      Optional.Absent,
    typeName: Optional[HookTypeName] = Optional.Absent,
    typeVersionId: Optional[HookTypeVersionId] = Optional.Absent,
    typeConfigurationVersionId: Optional[HookTypeConfigurationVersionId] =
      Optional.Absent,
    targetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ChangeSetHook = {
    import ChangeSetHook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHook
      .builder()
      .optionallyWith(invocationPoint.map(value => value.unwrap))(
        _.invocationPoint
      )
      .optionallyWith(failureMode.map(value => value.unwrap))(_.failureMode)
      .optionallyWith(
        typeName.map(value => HookTypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        typeVersionId.map(value =>
          HookTypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        typeConfigurationVersionId.map(value =>
          HookTypeConfigurationVersionId.unwrap(value): java.lang.String
        )
      )(_.typeConfigurationVersionId)
      .optionallyWith(targetDetails.map(value => value.buildAwsValue()))(
        _.targetDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ChangeSetHook.ReadOnly =
    zio.aws.cloudformation.model.ChangeSetHook.wrap(buildAwsValue())
}
object ChangeSetHook {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ChangeSetHook
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ChangeSetHook =
      zio.aws.cloudformation.model.ChangeSetHook(
        invocationPoint.map(value => value),
        failureMode.map(value => value),
        typeName.map(value => value),
        typeVersionId.map(value => value),
        typeConfigurationVersionId.map(value => value),
        targetDetails.map(value => value.asEditable)
      )
    def invocationPoint
        : Optional[zio.aws.cloudformation.model.HookInvocationPoint]
    def failureMode: Optional[zio.aws.cloudformation.model.HookFailureMode]
    def typeName: Optional[HookTypeName]
    def typeVersionId: Optional[HookTypeVersionId]
    def typeConfigurationVersionId: Optional[HookTypeConfigurationVersionId]
    def targetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly
    ]
    def getInvocationPoint
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookInvocationPoint] =
      AwsError.unwrapOptionField("invocationPoint", invocationPoint)
    def getFailureMode
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HookFailureMode] =
      AwsError.unwrapOptionField("failureMode", failureMode)
    def getTypeName: ZIO[Any, AwsError, HookTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getTypeVersionId: ZIO[Any, AwsError, HookTypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getTypeConfigurationVersionId
        : ZIO[Any, AwsError, HookTypeConfigurationVersionId] =
      AwsError.unwrapOptionField(
        "typeConfigurationVersionId",
        typeConfigurationVersionId
      )
    def getTargetDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly
    ] = AwsError.unwrapOptionField("targetDetails", targetDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHook
  ) extends zio.aws.cloudformation.model.ChangeSetHook.ReadOnly {
    override val invocationPoint
        : Optional[zio.aws.cloudformation.model.HookInvocationPoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationPoint())
        .map(value =>
          zio.aws.cloudformation.model.HookInvocationPoint.wrap(value)
        )
    override val failureMode
        : Optional[zio.aws.cloudformation.model.HookFailureMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMode())
        .map(value => zio.aws.cloudformation.model.HookFailureMode.wrap(value))
    override val typeName: Optional[HookTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.HookTypeName(value))
    override val typeVersionId: Optional[HookTypeVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeVersionId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.HookTypeVersionId(value)
        )
    override val typeConfigurationVersionId
        : Optional[HookTypeConfigurationVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.typeConfigurationVersionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .HookTypeConfigurationVersionId(value)
      )
    override val targetDetails: Optional[
      zio.aws.cloudformation.model.ChangeSetHookTargetDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDetails())
      .map(value =>
        zio.aws.cloudformation.model.ChangeSetHookTargetDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ChangeSetHook
  ): zio.aws.cloudformation.model.ChangeSetHook.ReadOnly = new Wrapper(impl)
}
