package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackPolicyBody
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStackPolicyResponse(
    stackPolicyBody: Optional[StackPolicyBody] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse = {
    import GetStackPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse
      .builder()
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly =
    zio.aws.cloudformation.model.GetStackPolicyResponse.wrap(buildAwsValue())
}
object GetStackPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetStackPolicyResponse =
      zio.aws.cloudformation.model
        .GetStackPolicyResponse(stackPolicyBody.map(value => value))
    def stackPolicyBody: Optional[StackPolicyBody]
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse
  ) extends zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly {
    override val stackPolicyBody: Optional[StackPolicyBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyBody())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse
  ): zio.aws.cloudformation.model.GetStackPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
