package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  Account,
  TemplateURL,
  StackSetName,
  ClientRequestToken,
  UsePreviousTemplate,
  RoleARN,
  Description,
  Region,
  ExecutionRoleName,
  TemplateBody
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStackSetRequest(
    stackSetName: StackSetName,
    description: Optional[Description] = Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent,
    usePreviousTemplate: Optional[UsePreviousTemplate] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = Optional.Absent,
    administrationRoleARN: Optional[RoleARN] = Optional.Absent,
    executionRoleName: Optional[ExecutionRoleName] = Optional.Absent,
    deploymentTargets: Optional[
      zio.aws.cloudformation.model.DeploymentTargets
    ] = Optional.Absent,
    permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels] =
      Optional.Absent,
    autoDeployment: Optional[zio.aws.cloudformation.model.AutoDeployment] =
      Optional.Absent,
    operationId: Optional[ClientRequestToken] = Optional.Absent,
    accounts: Optional[Iterable[Account]] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent,
    managedExecution: Optional[zio.aws.cloudformation.model.ManagedExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest = {
    import UpdateStackSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        usePreviousTemplate.map(value =>
          UsePreviousTemplate.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousTemplate)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        administrationRoleARN.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.administrationRoleARN)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackSetRequest.wrap(buildAwsValue())
}
object UpdateStackSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackSetRequest =
      zio.aws.cloudformation.model.UpdateStackSetRequest(
        stackSetName,
        description.map(value => value),
        templateBody.map(value => value),
        templateURL.map(value => value),
        usePreviousTemplate.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationPreferences.map(value => value.asEditable),
        administrationRoleARN.map(value => value),
        executionRoleName.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        permissionModel.map(value => value),
        autoDeployment.map(value => value.asEditable),
        operationId.map(value => value),
        accounts.map(value => value),
        regions.map(value => value),
        callAs.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: StackSetName
    def description: Optional[Description]
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def usePreviousTemplate: Optional[UsePreviousTemplate]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def administrationRoleARN: Optional[RoleARN]
    def executionRoleName: Optional[ExecutionRoleName]
    def deploymentTargets
        : Optional[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels]
    def autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def operationId: Optional[ClientRequestToken]
    def accounts: Optional[List[Account]]
    def regions: Optional[List[Region]]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getUsePreviousTemplate: ZIO[Any, AwsError, UsePreviousTemplate] =
      AwsError.unwrapOptionField("usePreviousTemplate", usePreviousTemplate)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getAdministrationRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("administrationRoleARN", administrationRoleARN)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ) extends zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val usePreviousTemplate: Optional[UsePreviousTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usePreviousTemplate())
        .map(value =>
          zio.aws.cloudformation.model.primitives.UsePreviousTemplate(value)
        )
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val administrationRoleARN: Optional[RoleARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrationRoleARN())
        .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val executionRoleName: Optional[ExecutionRoleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleName())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ExecutionRoleName(value)
        )
    override val deploymentTargets
        : Optional[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val permissionModel
        : Optional[zio.aws.cloudformation.model.PermissionModels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionModel())
        .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoDeployment())
        .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val accounts: Optional[List[Account]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Region(item)
        }.toList
      )
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
    override val managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedExecution())
        .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest
  ): zio.aws.cloudformation.model.UpdateStackSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
