package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait TypeTestsStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus
}
object TypeTestsStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus
  ): zio.aws.cloudformation.model.TypeTestsStatus = value match {
    case software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.NOT_TESTED =>
      val r = NOT_TESTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.TypeTestsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus =
      software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSED extends zio.aws.cloudformation.model.TypeTestsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus =
      software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.PASSED
  }
  case object FAILED extends zio.aws.cloudformation.model.TypeTestsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus =
      software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.FAILED
  }
  case object IN_PROGRESS extends zio.aws.cloudformation.model.TypeTestsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus =
      software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.IN_PROGRESS
  }
  case object NOT_TESTED extends zio.aws.cloudformation.model.TypeTestsStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus =
      software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus.NOT_TESTED
  }
}
