package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  TotalStackInstancesCount,
  FailedStackInstancesCount,
  Timestamp,
  DriftedStackInstancesCount,
  InProgressStackInstancesCount,
  InSyncStackInstancesCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StackSetDriftDetectionDetails(
    driftStatus: Optional[zio.aws.cloudformation.model.StackSetDriftStatus] =
      Optional.Absent,
    driftDetectionStatus: Optional[
      zio.aws.cloudformation.model.StackSetDriftDetectionStatus
    ] = Optional.Absent,
    lastDriftCheckTimestamp: Optional[Timestamp] = Optional.Absent,
    totalStackInstancesCount: Optional[TotalStackInstancesCount] =
      Optional.Absent,
    driftedStackInstancesCount: Optional[DriftedStackInstancesCount] =
      Optional.Absent,
    inSyncStackInstancesCount: Optional[InSyncStackInstancesCount] =
      Optional.Absent,
    inProgressStackInstancesCount: Optional[InProgressStackInstancesCount] =
      Optional.Absent,
    failedStackInstancesCount: Optional[FailedStackInstancesCount] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails = {
    import StackSetDriftDetectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
      .builder()
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(driftDetectionStatus.map(value => value.unwrap))(
        _.driftDetectionStatus
      )
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .optionallyWith(
        totalStackInstancesCount.map(value =>
          TotalStackInstancesCount.unwrap(value): Integer
        )
      )(_.totalStackInstancesCount)
      .optionallyWith(
        driftedStackInstancesCount.map(value =>
          DriftedStackInstancesCount.unwrap(value): Integer
        )
      )(_.driftedStackInstancesCount)
      .optionallyWith(
        inSyncStackInstancesCount.map(value =>
          InSyncStackInstancesCount.unwrap(value): Integer
        )
      )(_.inSyncStackInstancesCount)
      .optionallyWith(
        inProgressStackInstancesCount.map(value =>
          InProgressStackInstancesCount.unwrap(value): Integer
        )
      )(_.inProgressStackInstancesCount)
      .optionallyWith(
        failedStackInstancesCount.map(value =>
          FailedStackInstancesCount.unwrap(value): Integer
        )
      )(_.failedStackInstancesCount)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly =
    zio.aws.cloudformation.model.StackSetDriftDetectionDetails
      .wrap(buildAwsValue())
}
object StackSetDriftDetectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetDriftDetectionDetails =
      zio.aws.cloudformation.model.StackSetDriftDetectionDetails(
        driftStatus.map(value => value),
        driftDetectionStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value),
        totalStackInstancesCount.map(value => value),
        driftedStackInstancesCount.map(value => value),
        inSyncStackInstancesCount.map(value => value),
        inProgressStackInstancesCount.map(value => value),
        failedStackInstancesCount.map(value => value)
      )
    def driftStatus: Optional[zio.aws.cloudformation.model.StackSetDriftStatus]
    def driftDetectionStatus
        : Optional[zio.aws.cloudformation.model.StackSetDriftDetectionStatus]
    def lastDriftCheckTimestamp: Optional[Timestamp]
    def totalStackInstancesCount: Optional[TotalStackInstancesCount]
    def driftedStackInstancesCount: Optional[DriftedStackInstancesCount]
    def inSyncStackInstancesCount: Optional[InSyncStackInstancesCount]
    def inProgressStackInstancesCount: Optional[InProgressStackInstancesCount]
    def failedStackInstancesCount: Optional[FailedStackInstancesCount]
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getDriftDetectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetDriftDetectionStatus
    ] = AwsError.unwrapOptionField("driftDetectionStatus", driftDetectionStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
    def getTotalStackInstancesCount
        : ZIO[Any, AwsError, TotalStackInstancesCount] = AwsError
      .unwrapOptionField("totalStackInstancesCount", totalStackInstancesCount)
    def getDriftedStackInstancesCount
        : ZIO[Any, AwsError, DriftedStackInstancesCount] =
      AwsError.unwrapOptionField(
        "driftedStackInstancesCount",
        driftedStackInstancesCount
      )
    def getInSyncStackInstancesCount
        : ZIO[Any, AwsError, InSyncStackInstancesCount] = AwsError
      .unwrapOptionField("inSyncStackInstancesCount", inSyncStackInstancesCount)
    def getInProgressStackInstancesCount
        : ZIO[Any, AwsError, InProgressStackInstancesCount] =
      AwsError.unwrapOptionField(
        "inProgressStackInstancesCount",
        inProgressStackInstancesCount
      )
    def getFailedStackInstancesCount
        : ZIO[Any, AwsError, FailedStackInstancesCount] = AwsError
      .unwrapOptionField("failedStackInstancesCount", failedStackInstancesCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ) extends zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly {
    override val driftStatus
        : Optional[zio.aws.cloudformation.model.StackSetDriftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftStatus())
        .map(value =>
          zio.aws.cloudformation.model.StackSetDriftStatus.wrap(value)
        )
    override val driftDetectionStatus
        : Optional[zio.aws.cloudformation.model.StackSetDriftDetectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftDetectionStatus())
        .map(value =>
          zio.aws.cloudformation.model.StackSetDriftDetectionStatus.wrap(value)
        )
    override val lastDriftCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDriftCheckTimestamp())
        .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val totalStackInstancesCount: Optional[TotalStackInstancesCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStackInstancesCount())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .TotalStackInstancesCount(value)
        )
    override val driftedStackInstancesCount
        : Optional[DriftedStackInstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.driftedStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .DriftedStackInstancesCount(value)
      )
    override val inSyncStackInstancesCount
        : Optional[InSyncStackInstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.inSyncStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives.InSyncStackInstancesCount(value)
      )
    override val inProgressStackInstancesCount
        : Optional[InProgressStackInstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.inProgressStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .InProgressStackInstancesCount(value)
      )
    override val failedStackInstancesCount
        : Optional[FailedStackInstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failedStackInstancesCount())
      .map(value =>
        zio.aws.cloudformation.model.primitives.FailedStackInstancesCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails
  ): zio.aws.cloudformation.model.StackSetDriftDetectionDetails.ReadOnly =
    new Wrapper(impl)
}
