package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  RoleARN,
  StackNameOrId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RollbackStackRequest(
    stackName: StackNameOrId,
    roleARN: Optional[RoleARN] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest = {
    import RollbackStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest
      .builder()
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RollbackStackRequest.ReadOnly =
    zio.aws.cloudformation.model.RollbackStackRequest.wrap(buildAwsValue())
}
object RollbackStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RollbackStackRequest =
      zio.aws.cloudformation.model.RollbackStackRequest(
        stackName,
        roleARN.map(value => value),
        clientRequestToken.map(value => value)
      )
    def stackName: StackNameOrId
    def roleARN: Optional[RoleARN]
    def clientRequestToken: Optional[ClientRequestToken]
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest
  ) extends zio.aws.cloudformation.model.RollbackStackRequest.ReadOnly {
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest
  ): zio.aws.cloudformation.model.RollbackStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
