package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  MaxResults,
  NextToken,
  ClientRequestToken,
  StackSetName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStackSetOperationResultsRequest(
    stackSetName: StackSetName,
    operationId: ClientRequestToken,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.cloudformation.model.OperationResultFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest = {
    import ListStackSetOperationResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .operationId(ClientRequestToken.unwrap(operationId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListStackSetOperationResultsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListStackSetOperationResultsRequest
      .wrap(buildAwsValue())
}
object ListStackSetOperationResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.ListStackSetOperationResultsRequest =
      zio.aws.cloudformation.model.ListStackSetOperationResultsRequest(
        stackSetName,
        operationId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        callAs.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stackSetName: StackSetName
    def operationId: ClientRequestToken
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def filters: Optional[
      List[zio.aws.cloudformation.model.OperationResultFilter.ReadOnly]
    ]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getOperationId: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(operationId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.OperationResultFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest
  ) extends zio.aws.cloudformation.model.ListStackSetOperationResultsRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val operationId: ClientRequestToken =
      zio.aws.cloudformation.model.primitives
        .ClientRequestToken(impl.operationId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
    override val filters: Optional[
      List[zio.aws.cloudformation.model.OperationResultFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.OperationResultFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest
  ): zio.aws.cloudformation.model.ListStackSetOperationResultsRequest.ReadOnly =
    new Wrapper(impl)
}
