package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.HookInvocationCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Change(
    `type`: Optional[zio.aws.cloudformation.model.ChangeType] = Optional.Absent,
    hookInvocationCount: Optional[HookInvocationCount] = Optional.Absent,
    resourceChange: Optional[zio.aws.cloudformation.model.ResourceChange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Change = {
    import Change.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Change
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        hookInvocationCount.map(value =>
          HookInvocationCount.unwrap(value): Integer
        )
      )(_.hookInvocationCount)
      .optionallyWith(resourceChange.map(value => value.buildAwsValue()))(
        _.resourceChange
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Change.ReadOnly =
    zio.aws.cloudformation.model.Change.wrap(buildAwsValue())
}
object Change {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Change
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Change =
      zio.aws.cloudformation.model.Change(
        `type`.map(value => value),
        hookInvocationCount.map(value => value),
        resourceChange.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.cloudformation.model.ChangeType]
    def hookInvocationCount: Optional[HookInvocationCount]
    def resourceChange
        : Optional[zio.aws.cloudformation.model.ResourceChange.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeType] =
      AwsError.unwrapOptionField("type", `type`)
    def getHookInvocationCount: ZIO[Any, AwsError, HookInvocationCount] =
      AwsError.unwrapOptionField("hookInvocationCount", hookInvocationCount)
    def getResourceChange: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ResourceChange.ReadOnly
    ] = AwsError.unwrapOptionField("resourceChange", resourceChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Change
  ) extends zio.aws.cloudformation.model.Change.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.ChangeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.ChangeType.wrap(value))
    override val hookInvocationCount: Optional[HookInvocationCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hookInvocationCount())
        .map(value =>
          zio.aws.cloudformation.model.primitives.HookInvocationCount(value)
        )
    override val resourceChange
        : Optional[zio.aws.cloudformation.model.ResourceChange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceChange())
        .map(value => zio.aws.cloudformation.model.ResourceChange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Change
  ): zio.aws.cloudformation.model.Change.ReadOnly = new Wrapper(impl)
}
