package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait ChangeSource {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.ChangeSource
}
object ChangeSource {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.ChangeSource
  ): zio.aws.cloudformation.model.ChangeSource = value match {
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.RESOURCE_REFERENCE =>
      val r = ResourceReference
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.PARAMETER_REFERENCE =>
      val r = ParameterReference
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.RESOURCE_ATTRIBUTE =>
      val r = ResourceAttribute
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.DIRECT_MODIFICATION =>
      val r = DirectModification
      r
    case software.amazon.awssdk.services.cloudformation.model.ChangeSource.AUTOMATIC =>
      val r = Automatic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceReference
      extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.RESOURCE_REFERENCE
  }
  case object ParameterReference
      extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.PARAMETER_REFERENCE
  }
  case object ResourceAttribute
      extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.RESOURCE_ATTRIBUTE
  }
  case object DirectModification
      extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.DIRECT_MODIFICATION
  }
  case object Automatic extends zio.aws.cloudformation.model.ChangeSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.ChangeSource =
      software.amazon.awssdk.services.cloudformation.model.ChangeSource.AUTOMATIC
  }
}
