package zio.aws.cloudformation
import zio.aws.cloudformation.model.primitives.{
  Account,
  RegistrationToken,
  LogicalResourceId,
  SupportedMajorVersion,
  TransformName,
  StackName,
  NotificationARN,
  AllowedValue,
  StackId,
  ResourceType,
  ResourceToSkip,
  ResourceIdentifierPropertyValue,
  Region,
  OrganizationalUnitId,
  ResourceIdentifierPropertyKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.cloudformation.model.primitives.ClientRequestToken.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AcceptTermsAndConditions extends Subtype[Boolean]
    type AcceptTermsAndConditions =
      zio.aws.cloudformation.model.primitives.AcceptTermsAndConditions.Type
    object Account extends Subtype[String]
    type Account = zio.aws.cloudformation.model.primitives.Account.Type
    object AccountGateStatusReason extends Subtype[String]
    type AccountGateStatusReason =
      zio.aws.cloudformation.model.primitives.AccountGateStatusReason.Type
    object AccountsUrl extends Subtype[String]
    type AccountsUrl = zio.aws.cloudformation.model.primitives.AccountsUrl.Type
    object AllowedValue extends Subtype[String]
    type AllowedValue =
      zio.aws.cloudformation.model.primitives.AllowedValue.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.cloudformation.model.primitives.Arn.Type
    object AutoDeploymentNullable extends Subtype[Boolean]
    type AutoDeploymentNullable =
      zio.aws.cloudformation.model.primitives.AutoDeploymentNullable.Type
    object AutoUpdate extends Subtype[Boolean]
    type AutoUpdate = zio.aws.cloudformation.model.primitives.AutoUpdate.Type
    type BoxedInteger = Int
    object BoxedMaxResults extends Subtype[Int]
    type BoxedMaxResults =
      zio.aws.cloudformation.model.primitives.BoxedMaxResults.Type
    object CapabilitiesReason extends Subtype[String]
    type CapabilitiesReason =
      zio.aws.cloudformation.model.primitives.CapabilitiesReason.Type
    object CausingEntity extends Subtype[String]
    type CausingEntity =
      zio.aws.cloudformation.model.primitives.CausingEntity.Type
    object ChangeSetId extends Subtype[String]
    type ChangeSetId = zio.aws.cloudformation.model.primitives.ChangeSetId.Type
    object ChangeSetName extends Subtype[String]
    type ChangeSetName =
      zio.aws.cloudformation.model.primitives.ChangeSetName.Type
    object ChangeSetNameOrId extends Subtype[String]
    type ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives.ChangeSetNameOrId.Type
    object ChangeSetStatusReason extends Subtype[String]
    type ChangeSetStatusReason =
      zio.aws.cloudformation.model.primitives.ChangeSetStatusReason.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.cloudformation.model.primitives.ClientRequestToken.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.cloudformation.model.primitives.ClientToken.Type
    object ConfigurationSchema extends Subtype[String]
    type ConfigurationSchema =
      zio.aws.cloudformation.model.primitives.ConfigurationSchema.Type
    object ConnectionArn extends Subtype[String]
    type ConnectionArn =
      zio.aws.cloudformation.model.primitives.ConnectionArn.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime =
      zio.aws.cloudformation.model.primitives.CreationTime.Type
    object DeletionTime extends Subtype[Instant]
    type DeletionTime =
      zio.aws.cloudformation.model.primitives.DeletionTime.Type
    object Description extends Subtype[String]
    type Description = zio.aws.cloudformation.model.primitives.Description.Type
    object DisableRollback extends Subtype[Boolean]
    type DisableRollback =
      zio.aws.cloudformation.model.primitives.DisableRollback.Type
    object DriftedStackInstancesCount extends Subtype[Int]
    type DriftedStackInstancesCount =
      zio.aws.cloudformation.model.primitives.DriftedStackInstancesCount.Type
    object EnableTerminationProtection extends Subtype[Boolean]
    type EnableTerminationProtection =
      zio.aws.cloudformation.model.primitives.EnableTerminationProtection.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.cloudformation.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage =
      zio.aws.cloudformation.model.primitives.ErrorMessage.Type
    object EventId extends Subtype[String]
    type EventId = zio.aws.cloudformation.model.primitives.EventId.Type
    object ExecutionRoleName extends Subtype[String]
    type ExecutionRoleName =
      zio.aws.cloudformation.model.primitives.ExecutionRoleName.Type
    object ExportName extends Subtype[String]
    type ExportName = zio.aws.cloudformation.model.primitives.ExportName.Type
    object ExportValue extends Subtype[String]
    type ExportValue = zio.aws.cloudformation.model.primitives.ExportValue.Type
    object FailedStackInstancesCount extends Subtype[Int]
    type FailedStackInstancesCount =
      zio.aws.cloudformation.model.primitives.FailedStackInstancesCount.Type
    object FailureToleranceCount extends Subtype[Int]
    type FailureToleranceCount =
      zio.aws.cloudformation.model.primitives.FailureToleranceCount.Type
    object FailureTolerancePercentage extends Subtype[Int]
    type FailureTolerancePercentage =
      zio.aws.cloudformation.model.primitives.FailureTolerancePercentage.Type
    object HookInvocationCount extends Subtype[Int]
    type HookInvocationCount =
      zio.aws.cloudformation.model.primitives.HookInvocationCount.Type
    object HookStatusReason extends Subtype[String]
    type HookStatusReason =
      zio.aws.cloudformation.model.primitives.HookStatusReason.Type
    object HookTargetTypeName extends Subtype[String]
    type HookTargetTypeName =
      zio.aws.cloudformation.model.primitives.HookTargetTypeName.Type
    object HookType extends Subtype[String]
    type HookType = zio.aws.cloudformation.model.primitives.HookType.Type
    object HookTypeConfigurationVersionId extends Subtype[String]
    type HookTypeConfigurationVersionId =
      zio.aws.cloudformation.model.primitives.HookTypeConfigurationVersionId.Type
    object HookTypeName extends Subtype[String]
    type HookTypeName =
      zio.aws.cloudformation.model.primitives.HookTypeName.Type
    object HookTypeVersionId extends Subtype[String]
    type HookTypeVersionId =
      zio.aws.cloudformation.model.primitives.HookTypeVersionId.Type
    object InProgressStackInstancesCount extends Subtype[Int]
    type InProgressStackInstancesCount =
      zio.aws.cloudformation.model.primitives.InProgressStackInstancesCount.Type
    object InSyncStackInstancesCount extends Subtype[Int]
    type InSyncStackInstancesCount =
      zio.aws.cloudformation.model.primitives.InSyncStackInstancesCount.Type
    object IncludeNestedStacks extends Subtype[Boolean]
    type IncludeNestedStacks =
      zio.aws.cloudformation.model.primitives.IncludeNestedStacks.Type
    object IsActivated extends Subtype[Boolean]
    type IsActivated = zio.aws.cloudformation.model.primitives.IsActivated.Type
    object IsDefaultConfiguration extends Subtype[Boolean]
    type IsDefaultConfiguration =
      zio.aws.cloudformation.model.primitives.IsDefaultConfiguration.Type
    object IsDefaultVersion extends Subtype[Boolean]
    type IsDefaultVersion =
      zio.aws.cloudformation.model.primitives.IsDefaultVersion.Type
    object Key extends Subtype[String]
    type Key = zio.aws.cloudformation.model.primitives.Key.Type
    object LastUpdatedTime extends Subtype[Instant]
    type LastUpdatedTime =
      zio.aws.cloudformation.model.primitives.LastUpdatedTime.Type
    object LimitName extends Subtype[String]
    type LimitName = zio.aws.cloudformation.model.primitives.LimitName.Type
    object LimitValue extends Subtype[Int]
    type LimitValue = zio.aws.cloudformation.model.primitives.LimitValue.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName =
      zio.aws.cloudformation.model.primitives.LogGroupName.Type
    object LogicalIdHierarchy extends Subtype[String]
    type LogicalIdHierarchy =
      zio.aws.cloudformation.model.primitives.LogicalIdHierarchy.Type
    object LogicalResourceId extends Subtype[String]
    type LogicalResourceId =
      zio.aws.cloudformation.model.primitives.LogicalResourceId.Type
    object MajorVersion extends Subtype[Long]
    type MajorVersion =
      zio.aws.cloudformation.model.primitives.MajorVersion.Type
    object ManagedExecutionNullable extends Subtype[Boolean]
    type ManagedExecutionNullable =
      zio.aws.cloudformation.model.primitives.ManagedExecutionNullable.Type
    object MaxConcurrentCount extends Subtype[Int]
    type MaxConcurrentCount =
      zio.aws.cloudformation.model.primitives.MaxConcurrentCount.Type
    object MaxConcurrentPercentage extends Subtype[Int]
    type MaxConcurrentPercentage =
      zio.aws.cloudformation.model.primitives.MaxConcurrentPercentage.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.cloudformation.model.primitives.MaxResults.Type
    object Metadata extends Subtype[String]
    type Metadata = zio.aws.cloudformation.model.primitives.Metadata.Type
    object MonitoringTimeInMinutes extends Subtype[Int]
    type MonitoringTimeInMinutes =
      zio.aws.cloudformation.model.primitives.MonitoringTimeInMinutes.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.cloudformation.model.primitives.NextToken.Type
    object NoEcho extends Subtype[Boolean]
    type NoEcho = zio.aws.cloudformation.model.primitives.NoEcho.Type
    object NotificationARN extends Subtype[String]
    type NotificationARN =
      zio.aws.cloudformation.model.primitives.NotificationARN.Type
    object OptionalSecureUrl extends Subtype[String]
    type OptionalSecureUrl =
      zio.aws.cloudformation.model.primitives.OptionalSecureUrl.Type
    object OrganizationalUnitId extends Subtype[String]
    type OrganizationalUnitId =
      zio.aws.cloudformation.model.primitives.OrganizationalUnitId.Type
    object OutputKey extends Subtype[String]
    type OutputKey = zio.aws.cloudformation.model.primitives.OutputKey.Type
    object OutputValue extends Subtype[String]
    type OutputValue = zio.aws.cloudformation.model.primitives.OutputValue.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey =
      zio.aws.cloudformation.model.primitives.ParameterKey.Type
    object ParameterType extends Subtype[String]
    type ParameterType =
      zio.aws.cloudformation.model.primitives.ParameterType.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue =
      zio.aws.cloudformation.model.primitives.ParameterValue.Type
    object PhysicalResourceId extends Subtype[String]
    type PhysicalResourceId =
      zio.aws.cloudformation.model.primitives.PhysicalResourceId.Type
    object PrivateTypeArn extends Subtype[String]
    type PrivateTypeArn =
      zio.aws.cloudformation.model.primitives.PrivateTypeArn.Type
    object Properties extends Subtype[String]
    type Properties = zio.aws.cloudformation.model.primitives.Properties.Type
    object PropertyName extends Subtype[String]
    type PropertyName =
      zio.aws.cloudformation.model.primitives.PropertyName.Type
    object PropertyPath extends Subtype[String]
    type PropertyPath =
      zio.aws.cloudformation.model.primitives.PropertyPath.Type
    object PropertyValue extends Subtype[String]
    type PropertyValue =
      zio.aws.cloudformation.model.primitives.PropertyValue.Type
    object PublicVersionNumber extends Subtype[String]
    type PublicVersionNumber =
      zio.aws.cloudformation.model.primitives.PublicVersionNumber.Type
    object PublisherId extends Subtype[String]
    type PublisherId = zio.aws.cloudformation.model.primitives.PublisherId.Type
    object PublisherName extends Subtype[String]
    type PublisherName =
      zio.aws.cloudformation.model.primitives.PublisherName.Type
    object PublisherProfile extends Subtype[String]
    type PublisherProfile =
      zio.aws.cloudformation.model.primitives.PublisherProfile.Type
    object Reason extends Subtype[String]
    type Reason = zio.aws.cloudformation.model.primitives.Reason.Type
    object Region extends Subtype[String]
    type Region = zio.aws.cloudformation.model.primitives.Region.Type
    object RegistrationToken extends Subtype[String]
    type RegistrationToken =
      zio.aws.cloudformation.model.primitives.RegistrationToken.Type
    object RequestToken extends Subtype[String]
    type RequestToken =
      zio.aws.cloudformation.model.primitives.RequestToken.Type
    object ResourceIdentifierPropertyKey extends Subtype[String]
    type ResourceIdentifierPropertyKey =
      zio.aws.cloudformation.model.primitives.ResourceIdentifierPropertyKey.Type
    object ResourceIdentifierPropertyValue extends Subtype[String]
    type ResourceIdentifierPropertyValue =
      zio.aws.cloudformation.model.primitives.ResourceIdentifierPropertyValue.Type
    object ResourceModel extends Subtype[String]
    type ResourceModel =
      zio.aws.cloudformation.model.primitives.ResourceModel.Type
    object ResourceProperties extends Subtype[String]
    type ResourceProperties =
      zio.aws.cloudformation.model.primitives.ResourceProperties.Type
    object ResourceSignalUniqueId extends Subtype[String]
    type ResourceSignalUniqueId =
      zio.aws.cloudformation.model.primitives.ResourceSignalUniqueId.Type
    object ResourceStatusReason extends Subtype[String]
    type ResourceStatusReason =
      zio.aws.cloudformation.model.primitives.ResourceStatusReason.Type
    object ResourceToSkip extends Subtype[String]
    type ResourceToSkip =
      zio.aws.cloudformation.model.primitives.ResourceToSkip.Type
    object ResourceType extends Subtype[String]
    type ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType.Type
    object RetainStacks extends Subtype[Boolean]
    type RetainStacks =
      zio.aws.cloudformation.model.primitives.RetainStacks.Type
    object RetainStacksNullable extends Subtype[Boolean]
    type RetainStacksNullable =
      zio.aws.cloudformation.model.primitives.RetainStacksNullable.Type
    object RetainStacksOnAccountRemovalNullable extends Subtype[Boolean]
    type RetainStacksOnAccountRemovalNullable =
      zio.aws.cloudformation.model.primitives.RetainStacksOnAccountRemovalNullable.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.cloudformation.model.primitives.RoleARN.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.cloudformation.model.primitives.RoleArn.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.cloudformation.model.primitives.S3Bucket.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.cloudformation.model.primitives.S3Url.Type
    object StackDriftDetectionId extends Subtype[String]
    type StackDriftDetectionId =
      zio.aws.cloudformation.model.primitives.StackDriftDetectionId.Type
    object StackDriftDetectionStatusReason extends Subtype[String]
    type StackDriftDetectionStatusReason =
      zio.aws.cloudformation.model.primitives.StackDriftDetectionStatusReason.Type
    object StackId extends Subtype[String]
    type StackId = zio.aws.cloudformation.model.primitives.StackId.Type
    object StackIdsUrl extends Subtype[String]
    type StackIdsUrl = zio.aws.cloudformation.model.primitives.StackIdsUrl.Type
    object StackInstanceFilterValues extends Subtype[String]
    type StackInstanceFilterValues =
      zio.aws.cloudformation.model.primitives.StackInstanceFilterValues.Type
    object StackName extends Subtype[String]
    type StackName = zio.aws.cloudformation.model.primitives.StackName.Type
    object StackNameOrId extends Subtype[String]
    type StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId.Type
    object StackPolicyBody extends Subtype[String]
    type StackPolicyBody =
      zio.aws.cloudformation.model.primitives.StackPolicyBody.Type
    object StackPolicyDuringUpdateBody extends Subtype[String]
    type StackPolicyDuringUpdateBody =
      zio.aws.cloudformation.model.primitives.StackPolicyDuringUpdateBody.Type
    object StackPolicyDuringUpdateURL extends Subtype[String]
    type StackPolicyDuringUpdateURL =
      zio.aws.cloudformation.model.primitives.StackPolicyDuringUpdateURL.Type
    object StackPolicyURL extends Subtype[String]
    type StackPolicyURL =
      zio.aws.cloudformation.model.primitives.StackPolicyURL.Type
    object StackSetARN extends Subtype[String]
    type StackSetARN = zio.aws.cloudformation.model.primitives.StackSetARN.Type
    object StackSetId extends Subtype[String]
    type StackSetId = zio.aws.cloudformation.model.primitives.StackSetId.Type
    object StackSetName extends Subtype[String]
    type StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName.Type
    object StackSetNameOrId extends Subtype[String]
    type StackSetNameOrId =
      zio.aws.cloudformation.model.primitives.StackSetNameOrId.Type
    object StackSetOperationStatusReason extends Subtype[String]
    type StackSetOperationStatusReason =
      zio.aws.cloudformation.model.primitives.StackSetOperationStatusReason.Type
    object StackStatusReason extends Subtype[String]
    type StackStatusReason =
      zio.aws.cloudformation.model.primitives.StackStatusReason.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage =
      zio.aws.cloudformation.model.primitives.StatusMessage.Type
    object SupportedMajorVersion extends Subtype[Int]
    type SupportedMajorVersion =
      zio.aws.cloudformation.model.primitives.SupportedMajorVersion.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.cloudformation.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.cloudformation.model.primitives.TagValue.Type
    object TemplateBody extends Subtype[String]
    type TemplateBody =
      zio.aws.cloudformation.model.primitives.TemplateBody.Type
    object TemplateDescription extends Subtype[String]
    type TemplateDescription =
      zio.aws.cloudformation.model.primitives.TemplateDescription.Type
    object TemplateURL extends Subtype[String]
    type TemplateURL = zio.aws.cloudformation.model.primitives.TemplateURL.Type
    object ThirdPartyTypeArn extends Subtype[String]
    type ThirdPartyTypeArn =
      zio.aws.cloudformation.model.primitives.ThirdPartyTypeArn.Type
    object TimeoutMinutes extends Subtype[Int]
    type TimeoutMinutes =
      zio.aws.cloudformation.model.primitives.TimeoutMinutes.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.cloudformation.model.primitives.Timestamp.Type
    object TotalStackInstancesCount extends Subtype[Int]
    type TotalStackInstancesCount =
      zio.aws.cloudformation.model.primitives.TotalStackInstancesCount.Type
    object TransformName extends Subtype[String]
    type TransformName =
      zio.aws.cloudformation.model.primitives.TransformName.Type
    object Type extends Subtype[String]
    type Type = zio.aws.cloudformation.model.primitives.Type.Type
    object TypeArn extends Subtype[String]
    type TypeArn = zio.aws.cloudformation.model.primitives.TypeArn.Type
    object TypeConfiguration extends Subtype[String]
    type TypeConfiguration =
      zio.aws.cloudformation.model.primitives.TypeConfiguration.Type
    object TypeConfigurationAlias extends Subtype[String]
    type TypeConfigurationAlias =
      zio.aws.cloudformation.model.primitives.TypeConfigurationAlias.Type
    object TypeConfigurationArn extends Subtype[String]
    type TypeConfigurationArn =
      zio.aws.cloudformation.model.primitives.TypeConfigurationArn.Type
    object TypeHierarchy extends Subtype[String]
    type TypeHierarchy =
      zio.aws.cloudformation.model.primitives.TypeHierarchy.Type
    object TypeName extends Subtype[String]
    type TypeName = zio.aws.cloudformation.model.primitives.TypeName.Type
    object TypeNamePrefix extends Subtype[String]
    type TypeNamePrefix =
      zio.aws.cloudformation.model.primitives.TypeNamePrefix.Type
    object TypeSchema extends Subtype[String]
    type TypeSchema = zio.aws.cloudformation.model.primitives.TypeSchema.Type
    object TypeTestsStatusDescription extends Subtype[String]
    type TypeTestsStatusDescription =
      zio.aws.cloudformation.model.primitives.TypeTestsStatusDescription.Type
    object TypeVersionId extends Subtype[String]
    type TypeVersionId =
      zio.aws.cloudformation.model.primitives.TypeVersionId.Type
    object Url extends Subtype[String]
    type Url = zio.aws.cloudformation.model.primitives.Url.Type
    object UsePreviousTemplate extends Subtype[Boolean]
    type UsePreviousTemplate =
      zio.aws.cloudformation.model.primitives.UsePreviousTemplate.Type
    object UsePreviousValue extends Subtype[Boolean]
    type UsePreviousValue =
      zio.aws.cloudformation.model.primitives.UsePreviousValue.Type
    object Value extends Subtype[String]
    type Value = zio.aws.cloudformation.model.primitives.Value.Type
    object Version extends Subtype[String]
    type Version = zio.aws.cloudformation.model.primitives.Version.Type
  }
  type AccountLimitList = List[zio.aws.cloudformation.model.AccountLimit]
  type AccountList = List[Account]
  type AllowedValues = List[AllowedValue]
  type BatchDescribeTypeConfigurationsErrors =
    List[zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError]
  type Capabilities = List[zio.aws.cloudformation.model.Capability]
  type ChangeSetHooks = List[zio.aws.cloudformation.model.ChangeSetHook]
  type ChangeSetSummaries = List[zio.aws.cloudformation.model.ChangeSetSummary]
  type Changes = List[zio.aws.cloudformation.model.Change]
  type Exports = List[zio.aws.cloudformation.model.Export]
  type Imports = List[StackName]
  type LogicalResourceIds = List[LogicalResourceId]
  type NotificationARNs = List[NotificationARN]
  type OrganizationalUnitIdList = List[OrganizationalUnitId]
  type Outputs = List[zio.aws.cloudformation.model.Output]
  type ParameterDeclarations =
    List[zio.aws.cloudformation.model.ParameterDeclaration]
  type Parameters = List[zio.aws.cloudformation.model.Parameter]
  type PhysicalResourceIdContext =
    List[zio.aws.cloudformation.model.PhysicalResourceIdContextKeyValuePair]
  type PropertyDifferences =
    List[zio.aws.cloudformation.model.PropertyDifference]
  type RegionList = List[Region]
  type RegistrationTokenList = List[RegistrationToken]
  type RequiredActivatedTypes =
    List[zio.aws.cloudformation.model.RequiredActivatedType]
  type ResourceChangeDetails =
    List[zio.aws.cloudformation.model.ResourceChangeDetail]
  type ResourceIdentifierProperties =
    Map[ResourceIdentifierPropertyKey, ResourceIdentifierPropertyValue]
  type ResourceIdentifierSummaries =
    List[zio.aws.cloudformation.model.ResourceIdentifierSummary]
  type ResourceIdentifiers = List[ResourceIdentifierPropertyKey]
  type ResourceTypes = List[ResourceType]
  type ResourcesToImport = List[zio.aws.cloudformation.model.ResourceToImport]
  type ResourcesToSkip = List[ResourceToSkip]
  type RetainResources = List[LogicalResourceId]
  type RollbackTriggers = List[zio.aws.cloudformation.model.RollbackTrigger]
  type Scope = List[zio.aws.cloudformation.model.ResourceAttribute]
  type StackEvents = List[zio.aws.cloudformation.model.StackEvent]
  type StackIdList = List[StackId]
  type StackInstanceFilters =
    List[zio.aws.cloudformation.model.StackInstanceFilter]
  type StackInstanceSummaries =
    List[zio.aws.cloudformation.model.StackInstanceSummary]
  type StackResourceDriftStatusFilters =
    List[zio.aws.cloudformation.model.StackResourceDriftStatus]
  type StackResourceDrifts =
    List[zio.aws.cloudformation.model.StackResourceDrift]
  type StackResourceSummaries =
    List[zio.aws.cloudformation.model.StackResourceSummary]
  type StackResources = List[zio.aws.cloudformation.model.StackResource]
  type StackSetOperationResultSummaries =
    List[zio.aws.cloudformation.model.StackSetOperationResultSummary]
  type StackSetOperationSummaries =
    List[zio.aws.cloudformation.model.StackSetOperationSummary]
  type StackSetSummaries = List[zio.aws.cloudformation.model.StackSetSummary]
  type StackStatusFilter = List[zio.aws.cloudformation.model.StackStatus]
  type StackSummaries = List[zio.aws.cloudformation.model.StackSummary]
  type Stacks = List[zio.aws.cloudformation.model.Stack]
  type StageList = List[zio.aws.cloudformation.model.TemplateStage]
  type SupportedMajorVersions = List[SupportedMajorVersion]
  type Tags = List[zio.aws.cloudformation.model.Tag]
  type TemplateParameters = List[zio.aws.cloudformation.model.TemplateParameter]
  type TransformsList = List[TransformName]
  type TypeConfigurationDetailsList =
    List[zio.aws.cloudformation.model.TypeConfigurationDetails]
  type TypeConfigurationIdentifiers =
    List[zio.aws.cloudformation.model.TypeConfigurationIdentifier]
  type TypeSummaries = List[zio.aws.cloudformation.model.TypeSummary]
  type TypeVersionSummaries =
    List[zio.aws.cloudformation.model.TypeVersionSummary]
  type UnprocessedTypeConfigurations =
    List[zio.aws.cloudformation.model.TypeConfigurationIdentifier]
}
