package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTerminationProtectionResponse(
    stackId: Optional[StackId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse = {
    import UpdateTerminationProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly =
    zio.aws.cloudformation.model.UpdateTerminationProtectionResponse
      .wrap(buildAwsValue())
}
object UpdateTerminationProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.UpdateTerminationProtectionResponse =
      zio.aws.cloudformation.model
        .UpdateTerminationProtectionResponse(stackId.map(value => value))
    def stackId: Optional[StackId]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse
  ) extends zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly {
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse
  ): zio.aws.cloudformation.model.UpdateTerminationProtectionResponse.ReadOnly =
    new Wrapper(impl)
}
