package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TypeArn, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTypeRegistrationResponse(
    progressStatus: Optional[zio.aws.cloudformation.model.RegistrationStatus] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    typeArn: Optional[TypeArn] = Optional.Absent,
    typeVersionArn: Optional[TypeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse = {
    import DescribeTypeRegistrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse
      .builder()
      .optionallyWith(progressStatus.map(value => value.unwrap))(
        _.progressStatus
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        typeArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeArn)
      .optionallyWith(
        typeVersionArn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.typeVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeRegistrationResponse
      .wrap(buildAwsValue())
}
object DescribeTypeRegistrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeTypeRegistrationResponse =
      zio.aws.cloudformation.model.DescribeTypeRegistrationResponse(
        progressStatus.map(value => value),
        description.map(value => value),
        typeArn.map(value => value),
        typeVersionArn.map(value => value)
      )
    def progressStatus
        : Optional[zio.aws.cloudformation.model.RegistrationStatus]
    def description: Optional[Description]
    def typeArn: Optional[TypeArn]
    def typeVersionArn: Optional[TypeArn]
    def getProgressStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistrationStatus] =
      AwsError.unwrapOptionField("progressStatus", progressStatus)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTypeArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeArn", typeArn)
    def getTypeVersionArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("typeVersionArn", typeVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse
  ) extends zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly {
    override val progressStatus
        : Optional[zio.aws.cloudformation.model.RegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressStatus())
        .map(value =>
          zio.aws.cloudformation.model.RegistrationStatus.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val typeArn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.typeArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val typeVersionArn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.typeVersionArn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse
  ): zio.aws.cloudformation.model.DescribeTypeRegistrationResponse.ReadOnly =
    new Wrapper(impl)
}
