package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStacksResponse(
    stacks: Optional[Iterable[zio.aws.cloudformation.model.Stack]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse = {
    import DescribeStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
      .builder()
      .optionallyWith(
        stacks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stacks)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStacksResponse.wrap(buildAwsValue())
}
object DescribeStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStacksResponse =
      zio.aws.cloudformation.model.DescribeStacksResponse(
        stacks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stacks: Optional[List[zio.aws.cloudformation.model.Stack.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getStacks: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Stack.ReadOnly
    ]] = AwsError.unwrapOptionField("stacks", stacks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ) extends zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly {
    override val stacks
        : Optional[List[zio.aws.cloudformation.model.Stack.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stacks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Stack.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse
  ): zio.aws.cloudformation.model.DescribeStacksResponse.ReadOnly = new Wrapper(
    impl
  )
}
