package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDescribeTypeConfigurationsResponse(
    errors: Optional[Iterable[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
    ]] = Optional.Absent,
    unprocessedTypeConfigurations: Optional[
      Iterable[zio.aws.cloudformation.model.TypeConfigurationIdentifier]
    ] = Optional.Absent,
    typeConfigurations: Optional[
      Iterable[zio.aws.cloudformation.model.TypeConfigurationDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse = {
    import BatchDescribeTypeConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        unprocessedTypeConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedTypeConfigurations)
      .optionallyWith(
        typeConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typeConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly =
    zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse
      .wrap(buildAwsValue())
}
object BatchDescribeTypeConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse =
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedTypeConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        typeConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]]
    def unprocessedTypeConfigurations: Optional[
      List[zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly]
    ]
    def typeConfigurations: Optional[
      List[zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getUnprocessedTypeConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedTypeConfigurations",
      unprocessedTypeConfigurations
    )
    def getTypeConfigurations: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("typeConfigurations", typeConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ) extends zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly {
    override val errors: Optional[List[
      zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsError
            .wrap(item)
        }.toList
      )
    override val unprocessedTypeConfigurations: Optional[
      List[zio.aws.cloudformation.model.TypeConfigurationIdentifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedTypeConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TypeConfigurationIdentifier.wrap(item)
        }.toList
      )
    override val typeConfigurations: Optional[
      List[zio.aws.cloudformation.model.TypeConfigurationDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.typeConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TypeConfigurationDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
  ): zio.aws.cloudformation.model.BatchDescribeTypeConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
