package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  NextToken,
  PublisherId,
  TypeArn,
  MaxResults,
  TypeName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTypeVersionsRequest(
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    arn: Optional[TypeArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    deprecatedStatus: Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest = {
    import ListTypeVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(deprecatedStatus.map(value => value.unwrap))(
        _.deprecatedStatus
      )
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly =
    zio.aws.cloudformation.model.ListTypeVersionsRequest.wrap(buildAwsValue())
}
object ListTypeVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ListTypeVersionsRequest =
      zio.aws.cloudformation.model.ListTypeVersionsRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        arn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        deprecatedStatus.map(value => value),
        publisherId.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def arn: Optional[TypeArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus]
    def publisherId: Optional[PublisherId]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDeprecatedStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.DeprecatedStatus] =
      AwsError.unwrapOptionField("deprecatedStatus", deprecatedStatus)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ) extends zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val arn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cloudformation.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val deprecatedStatus
        : Optional[zio.aws.cloudformation.model.DeprecatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecatedStatus())
        .map(value => zio.aws.cloudformation.model.DeprecatedStatus.wrap(value))
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest
  ): zio.aws.cloudformation.model.ListTypeVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
