package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TypeNamePrefix, PublisherId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TypeFilters(
    category: Optional[zio.aws.cloudformation.model.Category] = Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent,
    typeNamePrefix: Optional[TypeNamePrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeFilters = {
    import TypeFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeFilters
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        typeNamePrefix.map(value =>
          TypeNamePrefix.unwrap(value): java.lang.String
        )
      )(_.typeNamePrefix)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TypeFilters.ReadOnly =
    zio.aws.cloudformation.model.TypeFilters.wrap(buildAwsValue())
}
object TypeFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeFilters =
      zio.aws.cloudformation.model.TypeFilters(
        category.map(value => value),
        publisherId.map(value => value),
        typeNamePrefix.map(value => value)
      )
    def category: Optional[zio.aws.cloudformation.model.Category]
    def publisherId: Optional[PublisherId]
    def typeNamePrefix: Optional[TypeNamePrefix]
    def getCategory: ZIO[Any, AwsError, zio.aws.cloudformation.model.Category] =
      AwsError.unwrapOptionField("category", category)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getTypeNamePrefix: ZIO[Any, AwsError, TypeNamePrefix] =
      AwsError.unwrapOptionField("typeNamePrefix", typeNamePrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ) extends zio.aws.cloudformation.model.TypeFilters.ReadOnly {
    override val category: Optional[zio.aws.cloudformation.model.Category] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value => zio.aws.cloudformation.model.Category.wrap(value))
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val typeNamePrefix: Optional[TypeNamePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeNamePrefix())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TypeNamePrefix(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeFilters
  ): zio.aws.cloudformation.model.TypeFilters.ReadOnly = new Wrapper(impl)
}
