package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  StackSetOperationStatusReason,
  Timestamp,
  ClientRequestToken
}
import scala.jdk.CollectionConverters._
final case class StackSetOperationSummary(
    operationId: Optional[ClientRequestToken] = Optional.Absent,
    action: Optional[zio.aws.cloudformation.model.StackSetOperationAction] =
      Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.StackSetOperationStatus] =
      Optional.Absent,
    creationTimestamp: Optional[Timestamp] = Optional.Absent,
    endTimestamp: Optional[Timestamp] = Optional.Absent,
    statusReason: Optional[StackSetOperationStatusReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary = {
    import StackSetOperationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .optionallyWith(
        statusReason.map(value =>
          StackSetOperationStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSetOperationSummary.wrap(buildAwsValue())
}
object StackSetOperationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetOperationSummary =
      zio.aws.cloudformation.model.StackSetOperationSummary(
        operationId.map(value => value),
        action.map(value => value),
        status.map(value => value),
        creationTimestamp.map(value => value),
        endTimestamp.map(value => value),
        statusReason.map(value => value)
      )
    def operationId: Optional[ClientRequestToken]
    def action: Optional[zio.aws.cloudformation.model.StackSetOperationAction]
    def status: Optional[zio.aws.cloudformation.model.StackSetOperationStatus]
    def creationTimestamp: Optional[Timestamp]
    def endTimestamp: Optional[Timestamp]
    def statusReason: Optional[StackSetOperationStatusReason]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationAction
    ] = AwsError.unwrapOptionField("action", action)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
    def getStatusReason: ZIO[Any, AwsError, StackSetOperationStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ) extends zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly {
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val action
        : Optional[zio.aws.cloudformation.model.StackSetOperationAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value =>
          zio.aws.cloudformation.model.StackSetOperationAction.wrap(value)
        )
    override val status
        : Optional[zio.aws.cloudformation.model.StackSetOperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.StackSetOperationStatus.wrap(value)
        )
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val endTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTimestamp())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val statusReason: Optional[StackSetOperationStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .StackSetOperationStatusReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary
  ): zio.aws.cloudformation.model.StackSetOperationSummary.ReadOnly =
    new Wrapper(impl)
}
