package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.AllowedValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterConstraints(
    allowedValues: Optional[Iterable[AllowedValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ParameterConstraints = {
    import ParameterConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ParameterConstraints
      .builder()
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            AllowedValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ParameterConstraints.ReadOnly =
    zio.aws.cloudformation.model.ParameterConstraints.wrap(buildAwsValue())
}
object ParameterConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ParameterConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ParameterConstraints =
      zio.aws.cloudformation.model
        .ParameterConstraints(allowedValues.map(value => value))
    def allowedValues: Optional[List[AllowedValue]]
    def getAllowedValues: ZIO[Any, AwsError, List[AllowedValue]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterConstraints
  ) extends zio.aws.cloudformation.model.ParameterConstraints.ReadOnly {
    override val allowedValues: Optional[List[AllowedValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.AllowedValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ParameterConstraints
  ): zio.aws.cloudformation.model.ParameterConstraints.ReadOnly = new Wrapper(
    impl
  )
}
