package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.TypeConfigurationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetTypeConfigurationResponse(
    configurationArn: Optional[TypeConfigurationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse = {
    import SetTypeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse
      .builder()
      .optionallyWith(
        configurationArn.map(value =>
          TypeConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.configurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly =
    zio.aws.cloudformation.model.SetTypeConfigurationResponse
      .wrap(buildAwsValue())
}
object SetTypeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.SetTypeConfigurationResponse =
      zio.aws.cloudformation.model
        .SetTypeConfigurationResponse(configurationArn.map(value => value))
    def configurationArn: Optional[TypeConfigurationArn]
    def getConfigurationArn: ZIO[Any, AwsError, TypeConfigurationArn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse
  ) extends zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly {
    override val configurationArn: Optional[TypeConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationArn())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TypeConfigurationArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse
  ): zio.aws.cloudformation.model.SetTypeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
