package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetectStackResourceDriftResponse(
    stackResourceDrift: zio.aws.cloudformation.model.StackResourceDrift
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse = {
    import DetectStackResourceDriftResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse
      .builder()
      .stackResourceDrift(stackResourceDrift.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly =
    zio.aws.cloudformation.model.DetectStackResourceDriftResponse
      .wrap(buildAwsValue())
}
object DetectStackResourceDriftResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DetectStackResourceDriftResponse =
      zio.aws.cloudformation.model
        .DetectStackResourceDriftResponse(stackResourceDrift.asEditable)
    def stackResourceDrift
        : zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
    def getStackResourceDrift: ZIO[
      Any,
      Nothing,
      zio.aws.cloudformation.model.StackResourceDrift.ReadOnly
    ] = ZIO.succeed(stackResourceDrift)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse
  ) extends zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly {
    override val stackResourceDrift
        : zio.aws.cloudformation.model.StackResourceDrift.ReadOnly =
      zio.aws.cloudformation.model.StackResourceDrift
        .wrap(impl.stackResourceDrift())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse
  ): zio.aws.cloudformation.model.DetectStackResourceDriftResponse.ReadOnly =
    new Wrapper(impl)
}
